/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismDataMaps;
import de.teamlapen.vampirism.api.datamaps.IFluidBloodConversion;
import de.teamlapen.vampirism.api.datamaps.IItemBlood;
import de.teamlapen.vampirism.api.general.IBloodConversionRegistry;
import de.teamlapen.vampirism.core.ModDataMaps;
import de.teamlapen.vampirism.datamaps.FluidBloodConversion;
import de.teamlapen.vampirism.datamaps.ItemBlood;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class BloodConversionRegistry
implements IBloodConversionRegistry {
    private final IItemBlood EMPTY = new ItemBlood(0);
    private final Map<Item, IItemBlood> CALCULATED = new HashMap<Item, IItemBlood>();

    @Override
    public int getImpureBloodValue(@NotNull Item item) {
        return this.getItemBlood(new ItemStack((ItemLike)item)).blood();
    }

    @Override
    public boolean canBeConverted(@NotNull ItemStack stack) {
        return this.getItemBlood(stack).blood() > 0;
    }

    @Override
    @NotNull
    public IItemBlood getItemBlood(@NotNull ItemStack stack) {
        IItemBlood data = (IItemBlood)stack.getItemHolder().getData(VampirismDataMaps.ITEM_BLOOD.get());
        if (data == null) {
            data = this.CALCULATED.get(stack.getItem());
        }
        if (data == null) {
            FoodProperties food = stack.getFoodProperties(null);
            data = food != null && stack.is(ItemTags.MEAT) && !BloodConversionRegistry.id(stack.getItem()).getPath().contains("cooked") ? new ItemBlood(food.nutrition() * 10) : this.EMPTY;
            this.CALCULATED.put(stack.getItem(), data);
        }
        return data;
    }

    private float getBloodValue(@NotNull FluidStack fluid) {
        return this.getFluidConversion(fluid.getFluid()).conversionRate();
    }

    @Override
    @NotNull
    public IFluidBloodConversion getFluidConversion(@NotNull Fluid fluid) {
        Map dataMap = BuiltInRegistries.FLUID.getDataMap(VampirismDataMaps.FLUID_BLOOD_CONVERSION.get());
        IFluidBloodConversion conversion = (IFluidBloodConversion)BuiltInRegistries.FLUID.wrapAsHolder((Object)fluid).getData(ModDataMaps.FLUID_BLOOD_CONVERSION_MAP);
        if (conversion != null) {
            return conversion;
        }
        return FluidBloodConversion.NONE;
    }

    @Override
    public boolean hasConversion(@NotNull Fluid fluid) {
        return this.getFluidConversion(fluid).conversionRate() != 0.0f;
    }

    @Override
    @NotNull
    public FluidStack getBloodFromFluid(@NotNull FluidStack fluid) {
        if (fluid.getFluid().isSame(VReference.BLOOD.get())) {
            return fluid;
        }
        return new FluidStack(VReference.BLOOD.get(), (int)(this.getBloodValue(fluid) * (float)fluid.getAmount()));
    }

    @NotNull
    private static ResourceLocation id(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @NotNull
    private static ResourceLocation id(Fluid block) {
        return BuiltInRegistries.FLUID.getKey((Object)block);
    }

    public void reload() {
        this.CALCULATED.clear();
    }
}

