/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.config.VampirismConfig;
import net.neoforged.neoforge.event.ModMismatchEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionUpdater {
    @Nullable
    private static ArtifactVersion oldVersion;
    @Nullable
    private static ArtifactVersion newVersion;

    public static void catchModVersionMismatch(ModMismatchEvent event) {
        event.getVersionDifference("vampirism").ifPresent(info -> {
            oldVersion = info.oldVersion();
            newVersion = info.newVersion();
        });
    }

    public static void checkVersionUpdated(ServerStartingEvent event) {
        if (oldVersion != null && newVersion != null) {
            VersionUpdater.update(oldVersion, newVersion);
        }
    }

    private static void update(@NotNull ArtifactVersion oldVersion, ArtifactVersion newVersion) {
        if (oldVersion.getMajorVersion() == 1 && oldVersion.getMinorVersion() == 9 && newVersion.getMajorVersion() == 1 && newVersion.getMinorVersion() == 10) {
            VersionUpdater.update1_9to1_10();
        }
    }

    private static void update1_9to1_10() {
        double skillPointsPerLevel = (Double)VampirismConfig.BALANCE.skillPointsPerLevel.get();
        skillPointsPerLevel = skillPointsPerLevel == 1.0 ? (Double)VampirismConfig.BALANCE.skillPointsPerLevel.getDefault() : (skillPointsPerLevel *= 2.0);
        VampirismConfig.BALANCE.skillPointsPerLevel.set((Object)skillPointsPerLevel);
        double skillPointsPerLordLevel = (Double)VampirismConfig.BALANCE.skillPointsPerLordLevel.get();
        skillPointsPerLordLevel = skillPointsPerLordLevel == 1.0 ? (Double)VampirismConfig.BALANCE.skillPointsPerLordLevel.getDefault() : (skillPointsPerLordLevel *= 2.0);
        VampirismConfig.BALANCE.skillPointsPerLordLevel.set((Object)skillPointsPerLordLevel);
    }
}

