/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTags;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotemHelper {
    public static final int MIN_HOMES = 4;
    public static final int MIN_WORKSTATIONS = 2;
    public static final int MIN_VILLAGER = 4;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceKey<Level>, Map<BlockPos, BlockPos>> totemPositions = Maps.newHashMap();
    private static final Map<ResourceKey<Level>, Map<BlockPos, Set<PoiRecord>>> poiSets = Maps.newHashMap();

    public static boolean addTotem(@NotNull ServerLevel world, @NotNull Set<PoiRecord> pois, @NotNull BlockPos totemPos) {
        BlockPos conflict = null;
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent((ResourceKey<Level>)world.dimension(), key -> new HashMap());
        for (PoiRecord poi2 : pois) {
            if (!totemPositions.containsKey(poi2.getPos()) || ((BlockPos)totemPositions.get(poi2.getPos())).equals((Object)totemPos)) continue;
            conflict = (BlockPos)totemPositions.get(poi2.getPos());
            break;
        }
        if (conflict != null) {
            TotemHelper.handleTotemConflict(pois, world, totemPos, conflict);
        }
        if (pois.isEmpty()) {
            return false;
        }
        for (PoiRecord pointOfInterest : pois) {
            totemPositions.put(pointOfInterest.getPos(), totemPos);
        }
        totemPositions.put(totemPos, totemPos);
        Map poiSets = TotemHelper.poiSets.computeIfAbsent((ResourceKey<Level>)world.dimension(), key -> new HashMap());
        if (poiSets.containsKey(totemPos)) {
            ((Set)poiSets.get(totemPos)).forEach(poi -> {
                if (!pois.contains(poi)) {
                    totemPositions.remove(poi.getPos());
                }
            });
        }
        poiSets.put(totemPos, pois);
        return !pois.isEmpty();
    }

    private static void handleTotemConflict(@NotNull Set<PoiRecord> pois, @NotNull ServerLevel world, @NotNull BlockPos totem, @NotNull BlockPos conflicting) {
        boolean ignoreOtherTotem;
        TotemBlockEntity totem1 = (TotemBlockEntity)world.getBlockEntity(totem);
        TotemBlockEntity totem2 = (TotemBlockEntity)world.getBlockEntity(conflicting);
        if (totem2 == null) {
            return;
        }
        boolean bl = ignoreOtherTotem = totem1.getControllingFaction() == totem2.getControllingFaction();
        if (totem1.getCapturingFaction() != null || totem2.getCapturingFaction() != null) {
            ignoreOtherTotem = false;
        }
        Optional<StructureStart> structure1 = UtilLib.getStructureStartAt((Level)world, totem, (TagKey<Structure>)StructureTags.VILLAGE);
        Optional<StructureStart> structure2 = UtilLib.getStructureStartAt((Level)world, conflicting, (TagKey<Structure>)StructureTags.VILLAGE);
        if (structure1.isPresent() && structure2.isPresent()) {
            ignoreOtherTotem = false;
        }
        if (totem2.getSize() >= totem1.getSize()) {
            ignoreOtherTotem = false;
        }
        if (!ignoreOtherTotem) {
            pois.removeIf(poi -> !totem.equals((Object)totemPositions.get(world.dimension()).get(poi.getPos())));
        }
    }

    public static void removeTotem(ResourceKey<Level> dimension, @NotNull Collection<PoiRecord> pois, BlockPos pos, boolean removeTotem) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent(dimension, key -> new HashMap());
        pois.forEach(pointOfInterest -> totemPositions.remove(pointOfInterest.getPos(), pos));
        if (removeTotem) {
            totemPositions.remove(pos);
        }
    }

    @NotNull
    public static Optional<BlockPos> getTotemPosition(ResourceKey<Level> dimension, @NotNull Collection<PoiRecord> pois) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent(dimension, key -> new HashMap());
        for (PoiRecord pointOfInterest : pois) {
            if (!totemPositions.containsKey(pointOfInterest.getPos())) continue;
            return Optional.of((BlockPos)totemPositions.get(pointOfInterest.getPos()));
        }
        return Optional.empty();
    }

    @Nullable
    public static BlockPos getTotemPosition(ResourceKey<Level> world, BlockPos pos) {
        if (totemPositions.containsKey(world)) {
            return totemPositions.get(world).get(pos);
        }
        return null;
    }

    @NotNull
    public static Optional<BlockPos> getTotemPosNearPos(@NotNull ServerLevel world, @NotNull BlockPos pos) {
        Collection points = world.getPoiManager().getInRange(p -> true, pos, 25, PoiManager.Occupancy.ANY).collect(Collectors.toList());
        if (!points.isEmpty()) {
            return TotemHelper.getTotemPosition((ResourceKey<Level>)world.dimension(), points);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<TotemBlockEntity> getTotemNearPos(@NotNull ServerLevel world, @NotNull BlockPos posSource, boolean mustBeLoaded) {
        Optional<BlockPos> posOpt = TotemHelper.getTotemPosNearPos(world, posSource);
        if (mustBeLoaded) {
            posOpt = posOpt.filter(arg_0 -> ((ServerLevel)world).isPositionEntityTicking(arg_0));
        }
        return posOpt.map(pos -> {
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof TotemBlockEntity) {
                TotemBlockEntity totem = (TotemBlockEntity)tile;
                return totem;
            }
            return null;
        });
    }

    @NotNull
    public static Component forceFactionCommand(@Nullable IFaction<?> faction, @NotNull ServerPlayer player) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent((ResourceKey<Level>)player.getCommandSenderWorld().dimension(), key -> new HashMap());
        List<PoiRecord> pointOfInterests = ((ServerLevel)player.getCommandSenderWorld()).getPoiManager().getInRange(point -> true, player.blockPosition(), 25, PoiManager.Occupancy.ANY).sorted(Comparator.comparingInt(point -> (int)point.getPos().distSqr((Vec3i)player.blockPosition()))).toList();
        if (pointOfInterests.stream().noneMatch(point -> totemPositions.containsKey(point.getPos()))) {
            return Component.translatable((String)"command.vampirism.test.village.no_village");
        }
        BlockEntity te = player.getCommandSenderWorld().getBlockEntity((BlockPos)totemPositions.get(pointOfInterests.getFirst().getPos()));
        if (!(te instanceof TotemBlockEntity)) {
            LOGGER.warn("TileEntity at {} is no TotemTileEntity", totemPositions.get(pointOfInterests.getFirst().getPos()));
            return Component.literal((String)"");
        }
        TotemBlockEntity tile = (TotemBlockEntity)te;
        tile.setForcedFaction(faction);
        return Component.translatable((String)"command.vampirism.test.village.success", (Object[])new Object[]{faction == null ? "none" : faction.getName()});
    }

    @NotNull
    public static Set<PoiRecord> getVillagePointsOfInterest(@NotNull ServerLevel world, @NotNull BlockPos pos) {
        PoiManager manager = world.getPoiManager();
        HashSet finished = Sets.newHashSet();
        Set points = manager.getInRange(type -> !type.is(ModTags.PoiTypes.HAS_FACTION), pos, 50, PoiManager.Occupancy.ANY).collect(Collectors.toSet());
        while (!points.isEmpty()) {
            List<Stream> list = points.stream().map(pointOfInterest -> manager.getInRange(type -> !type.is(ModTags.PoiTypes.HAS_FACTION), pointOfInterest.getPos(), 40, PoiManager.Occupancy.ANY)).toList();
            points.clear();
            list.forEach(stream -> stream.forEach(point -> {
                if (!finished.contains(point) && point.getPos().closerThan((Vec3i)pos, (double)((Integer)VampirismConfig.BALANCE.viMaxTotemRadius.get()).intValue())) {
                    points.add(point);
                }
                finished.add(point);
            }));
        }
        return finished;
    }

    public static int isVillage(@NotNull Map<Integer, Integer> stats, boolean hasInteraction) {
        int status = 0;
        if (stats.get(1) >= 4) {
            ++status;
        }
        if (stats.get(2) >= 2) {
            status += 2;
        }
        if (hasInteraction || stats.get(4) >= 4) {
            status += 4;
        }
        return status;
    }

    public static int isVillage(@NotNull Set<PoiRecord> pointOfInterests, @NotNull ServerLevel world, @NotNull BlockPos totemPos, boolean hasInteraction) {
        if (UtilLib.getStructureStartAt((Level)world, totemPos, (TagKey<Structure>)StructureTags.VILLAGE).isPresent()) {
            return 7;
        }
        return TotemHelper.isVillage(TotemHelper.getVillageStats(pointOfInterests, (Level)world), hasInteraction);
    }

    @NotNull
    public static Map<Integer, Integer> getVillageStats(@NotNull Set<PoiRecord> pointOfInterests, final @NotNull Level world) {
        final Map poiTCounts = pointOfInterests.stream().map(PoiRecord::getPoiType).flatMap(a -> BuiltInRegistries.POINT_OF_INTEREST_TYPE.getResourceKey((Object)((PoiType)a.value())).stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        final AABB area = TotemHelper.getAABBAroundPOIs(pointOfInterests);
        return new HashMap<Integer, Integer>(){
            {
                this.put(1, poiTCounts.getOrDefault(PoiTypes.HOME, 0L).intValue());
                this.put(2, (int)poiTCounts.entrySet().stream().filter(entry -> entry.getKey() != PoiTypes.HOME).mapToLong(Map.Entry::getValue).sum());
                this.put(4, area == null ? 0 : world.getEntitiesOfClass(Villager.class, area).size());
            }
        };
    }

    @Nullable
    public static AABB getAABBAroundPOIs(@NotNull Set<PoiRecord> pois) {
        return pois.stream().map(poi -> new AABB(poi.getPos()).inflate(25.0)).reduce(AABB::minmax).orElse(null);
    }

    public static void ringBell(@NotNull Level world, @NotNull Player player) {
        if (!world.isClientSide) {
            Optional<TotemBlockEntity> tile = TotemHelper.getTotemNearPos((ServerLevel)world, player.blockPosition(), false);
            tile.ifPresent(s -> s.ringBell(player));
        }
    }

    public static Stream<PoiRecord> findRecords(ServerLevel level, BlockPos pos) {
        return TotemHelper.getInSquare(level.getPoiManager(), x -> x.is(PoiTypeTags.VILLAGE), pos, 1, PoiManager.Occupancy.ANY);
    }

    public static Stream<PoiRecord> getInSquare(PoiManager manager, Predicate<Holder<PoiType>> pTypePredicate, BlockPos pPos, int pDistance, PoiManager.Occupancy pStatus) {
        int i = Math.floorDiv(pDistance, 16) + 1;
        return ChunkPos.rangeClosed((ChunkPos)new ChunkPos(pPos), (int)i).flatMap(p_217938_ -> TotemHelper.getInChunk(manager, pTypePredicate, p_217938_, pStatus)).filter(p_217971_ -> {
            BlockPos blockpos = p_217971_.getPos();
            return Math.abs(blockpos.getX() - pPos.getX()) <= pDistance && Math.abs(blockpos.getZ() - pPos.getZ()) <= pDistance;
        });
    }

    public static Stream<PoiRecord> getInChunk(PoiManager poiManager, Predicate<Holder<PoiType>> pTypePredicate, ChunkPos pPosChunk, PoiManager.Occupancy pStatus) {
        return IntStream.range(poiManager.levelHeightAccessor.getMinSection(), poiManager.levelHeightAccessor.getMaxSection()).boxed().map(p_217886_ -> poiManager.get(SectionPos.of((ChunkPos)pPosChunk, (int)p_217886_).asLong())).filter(Objects::nonNull).filter(Optional::isPresent).flatMap(p_217942_ -> ((PoiSection)p_217942_.get()).getRecords(pTypePredicate, pStatus));
    }
}

