/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.server;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.storage.IAttachedSyncable;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.data.ServerSkillTreeData;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.TaskManager;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.inventory.HunterBasicMenu;
import de.teamlapen.vampirism.inventory.HunterTrainerMenu;
import de.teamlapen.vampirism.inventory.RevertBackMenu;
import de.teamlapen.vampirism.inventory.VampireBeaconMenu;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.items.VampireSwordItem;
import de.teamlapen.vampirism.network.ClientboundRequestMinionSelectPacket;
import de.teamlapen.vampirism.network.ClientboundSkillTreePacket;
import de.teamlapen.vampirism.network.ServerboundActionBindingPacket;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import de.teamlapen.vampirism.network.ServerboundDeleteRefinementPacket;
import de.teamlapen.vampirism.network.ServerboundNameItemPacket;
import de.teamlapen.vampirism.network.ServerboundRequestSkillTreePacket;
import de.teamlapen.vampirism.network.ServerboundSelectAmmoTypePacket;
import de.teamlapen.vampirism.network.ServerboundSelectMinionTaskPacket;
import de.teamlapen.vampirism.network.ServerboundSetVampireBeaconPacket;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import de.teamlapen.vampirism.network.ServerboundStartFeedingPacket;
import de.teamlapen.vampirism.network.ServerboundTaskActionPacket;
import de.teamlapen.vampirism.network.ServerboundToggleActionPacket;
import de.teamlapen.vampirism.network.ServerboundToggleMinionTaskLock;
import de.teamlapen.vampirism.network.ServerboundUnlockSkillPacket;
import de.teamlapen.vampirism.network.ServerboundUpgradeMinionStatPacket;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPayloadHandler {
    private static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();
    private static final Logger LOGGER = LogManager.getLogger();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleActionBindingPacket(ServerboundActionBindingPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> FactionPlayerHandler.get(context.player()).setBoundAction(msg.actionBindingId(), msg.action(), false, false));
    }

    public void handleAppearancePacket(ServerboundAppearancePacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity1 = context.player().level().getEntity(msg.entityId());
            if (entity1 instanceof Player) {
                Player player = (Player)entity1;
                VampirePlayer.get(player).setSkinData(msg.data());
            } else if (entity1 instanceof MinionEntity) {
                MinionEntity minion = (MinionEntity)entity1;
                minion.getMinionData().ifPresent(minionData -> minionData.handleMinionAppearanceConfig(msg.name(), msg.data()));
                HelperLib.sync(minion);
            }
        });
    }

    public void handleDeleteRefinementPacket(ServerboundDeleteRefinementPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> FactionPlayerHandler.getCurrentFactionPlayer(context.player()).ifPresent(fp -> fp.getSkillHandler().removeRefinementItem(msg.slot())));
    }

    public void handleNameItemPacket(ServerboundNameItemPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> msg.name().ifPresentOrElse(name -> {
            if (!StringUtils.isBlank((CharSequence)name)) {
                ItemStack stack = context.player().getMainHandItem();
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name).withStyle(ChatFormatting.AQUA));
            }
        }, () -> {
            ItemStack stack = context.player().getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof VampireSwordItem) {
                VampireSwordItem swordItem = (VampireSwordItem)patt0$temp;
                swordItem.doNotName(stack);
            }
        }));
    }

    public void handleSelectAmmoTypePacket(ServerboundSelectAmmoTypePacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            IVampirismCrossbow crossbow;
            ItemStack stack = context.player().getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof IVampirismCrossbow && (crossbow = (IVampirismCrossbow)patt0$temp).canSelectAmmunition(stack)) {
                crossbow.setAmmunition(stack, msg.ammoId());
            }
        });
    }

    public void handleSelectMinionTaskPacket(ServerboundSelectMinionTaskPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            FactionPlayerHandler fp = FactionPlayerHandler.get(context.player());
            PlayerMinionController controller = MinionWorldData.getData(context.player().level()).get().getOrCreateController(fp);
            if (ServerboundSelectMinionTaskPacket.RECALL.equals((Object)msg.taskID())) {
                if (msg.minionID() < 0) {
                    Collection<Integer> ids = controller.recallMinions(false);
                    for (Integer id : ids) {
                        controller.createMinionEntityAtPlayer(id, context.player());
                    }
                    ServerboundSelectMinionTaskPacket.printRecoveringMinions((ServerPlayer)context.player(), controller.getRecoveringMinionNames());
                } else if (controller.recallMinion(msg.minionID())) {
                    controller.createMinionEntityAtPlayer(msg.minionID(), context.player());
                } else {
                    context.player().displayClientMessage((Component)Component.translatable((String)"text.vampirism.minion_is_still_recovering", (Object[])new Object[]{controller.contactMinionData(msg.minionID(), MinionData::getFormattedName).orElseGet(() -> Component.literal((String)"1"))}), true);
                }
            } else if (ServerboundSelectMinionTaskPacket.RESPAWN.equals((Object)msg.taskID())) {
                Collection<Integer> ids = controller.getUnclaimedMinions();
                for (Integer id : ids) {
                    controller.createMinionEntityAtPlayer(id, context.player());
                }
                ServerboundSelectMinionTaskPacket.printRecoveringMinions((ServerPlayer)context.player(), controller.getRecoveringMinionNames());
            } else {
                IMinionTask<?, ?> task = RegUtil.getMinionTask(msg.taskID());
                if (task == null) {
                    LOGGER.error("Cannot find action to activate {}", (Object)msg.taskID());
                } else if (msg.minionID() < -1) {
                    LOGGER.error("Illegal minion id {}", (Object)msg.minionID());
                } else {
                    controller.activateTask(msg.minionID(), task);
                }
            }
        });
    }

    public void handleSetVampireBeaconPacket(ServerboundSetVampireBeaconPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            VampireBeaconMenu beaconMenu;
            AbstractContainerMenu patt0$temp = context.player().containerMenu;
            if (patt0$temp instanceof VampireBeaconMenu && (beaconMenu = (VampireBeaconMenu)patt0$temp).stillValid(context.player())) {
                beaconMenu.updateEffects(msg.effect(), msg.amplifier());
            }
        });
    }

    public void handleSimpleInputEvent(ServerboundSimpleInputEvent msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            Optional<IFactionPlayer<?>> factionPlayerOpt = FactionPlayerHandler.getCurrentFactionPlayer((Player)player);
            switch (msg.event()) {
                case FINISH_SUCK_BLOOD: {
                    VampirePlayer.get((Player)player).endFeeding(true);
                    break;
                }
                case RESET_SKILLS: {
                    InventoryHelper.removeItemFromInventory((Container)player.getInventory(), new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get()));
                    factionPlayerOpt.ifPresent(OblivionItem::applyEffect);
                    break;
                }
                case REVERT_BACK: {
                    AbstractContainerMenu patt0$temp = player.containerMenu;
                    if (patt0$temp instanceof RevertBackMenu) {
                        RevertBackMenu menu = (RevertBackMenu)patt0$temp;
                        menu.consume();
                    }
                    FactionPlayerHandler.get((Player)player).leaveFaction(!player.server.isHardcore());
                    break;
                }
                case TOGGLE_VAMPIRE_VISION: {
                    VampirePlayer.get((Player)player).switchVision();
                    break;
                }
                case TRAINER_LEVELUP: {
                    if (!(player.containerMenu instanceof HunterTrainerMenu)) break;
                    ((HunterTrainerMenu)player.containerMenu).onLevelupClicked();
                    break;
                }
                case BASIC_HUNTER_LEVELUP: {
                    if (!(player.containerMenu instanceof HunterBasicMenu)) break;
                    ((HunterBasicMenu)player.containerMenu).onLevelUpClicked();
                    break;
                }
                case SHOW_MINION_CALL_SELECTION: {
                    ClientboundRequestMinionSelectPacket.createRequestForPlayer(player, ClientboundRequestMinionSelectPacket.Action.CALL).ifPresent(a -> player.connection.send((CustomPacketPayload)a));
                    break;
                }
                case VAMPIRISM_MENU: {
                    factionPlayerOpt.ifPresent(fPlayer -> fPlayer.getTaskManager().openVampirismMenu());
                    break;
                }
                case RESURRECT: {
                    VampirePlayer.get((Player)player).tryResurrect();
                    break;
                }
                case GIVE_UP: {
                    VampirePlayer.get((Player)player).giveUpDBNO();
                }
            }
        });
    }

    public void handleStartFeedingPacket(ServerboundStartFeedingPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            VampirePlayer vampire = VampirePlayer.get(context.player());
            msg.target().ifLeft(vampire::biteEntity);
            msg.target().ifRight(vampire::biteBlock);
        });
    }

    public void handleTaskActionPacket(ServerboundTaskActionPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> FactionPlayerHandler.getCurrentFactionPlayer(context.player()).map(IFactionPlayer::getTaskManager).ifPresent(m -> ((TaskManager)m).handleTaskActionMessage(msg)));
    }

    public void handleToggleActionPacket(ServerboundToggleActionPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Optional<IFactionPlayer<?>> factionPlayerOpt = FactionPlayerHandler.getCurrentFactionPlayer(player);
            factionPlayerOpt.ifPresent(factionPlayer -> {
                ActionHandler.ActivationContext activationContext = msg.target() != null ? (IAction.ActivationContext)msg.target().map(entityId -> {
                    Entity e = player.getCommandSenderWorld().getEntity(entityId.intValue());
                    if (e == null) {
                        LOGGER.warn("Could not find entity {} the player was looking at when toggling action", entityId);
                    }
                    return new ActionHandler.ActivationContext(e);
                }, ActionHandler.ActivationContext::new) : new ActionHandler.ActivationContext();
                IActionHandler<?> actionHandler = factionPlayer.getActionHandler();
                IAction<?> action = RegUtil.getAction(msg.actionId());
                if (action != null) {
                    IAction.PERM r = actionHandler.toggleAction(action, activationContext);
                    switch (r) {
                        case NOT_UNLOCKED: {
                            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.action.not_unlocked"), true);
                            break;
                        }
                        case DISABLED: {
                            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.action.deactivated_by_serveradmin"), false);
                            break;
                        }
                        case COOLDOWN: {
                            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.action.cooldown_not_over"), true);
                            break;
                        }
                        case DISALLOWED: {
                            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.action.disallowed"), true);
                            break;
                        }
                        case PERMISSION_DISALLOWED: {
                            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.action.permission_disallowed"), false);
                            break;
                        }
                    }
                } else {
                    LOGGER.error("Failed to find action with id {}", (Object)msg.actionId());
                }
            });
        });
    }

    public void handleToggleMinionTaskLock(ServerboundToggleMinionTaskLock msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            FactionPlayerHandler fp = FactionPlayerHandler.get(context.player());
            PlayerMinionController controller = MinionWorldData.getData(context.player().level()).get().getOrCreateController(fp);
            controller.contactMinionData(msg.minionID(), data -> data.setTaskLocked(!data.isTaskLocked()));
            controller.contactMinion(msg.minionID(), MinionEntity::onTaskChanged);
        });
    }

    public void handleUnlockSkillPacket(ServerboundUnlockSkillPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Optional<IFactionPlayer<?>> factionPlayerOpt = FactionPlayerHandler.getCurrentFactionPlayer(player);
            factionPlayerOpt.ifPresent(factionPlayer -> {
                ISkill<?> skill = RegUtil.getSkill(msg.skillId());
                if (skill != null) {
                    ISkillHandler<?> skillHandler = factionPlayer.getSkillHandler();
                    ISkillHandler.Result result = skillHandler.canSkillBeEnabled(skill);
                    if (result == ISkillHandler.Result.OK) {
                        skillHandler.enableSkill(skill);
                        if (factionPlayer instanceof IAttachedSyncable && skillHandler instanceof SkillHandler) {
                            SkillHandler skillHandler1 = (SkillHandler)skillHandler;
                            CompoundTag sync = new CompoundTag();
                            sync.put(skillHandler1.nbtKey(), (Tag)skillHandler1.serializeUpdateNBT((HolderLookup.Provider)player.registryAccess()));
                            HelperLib.sync((IAttachedSyncable)((Object)factionPlayer), sync, ((IAttachedSyncable)((Object)factionPlayer)).asEntity(), true);
                        }
                    } else {
                        LOGGER.warn("Skill {} cannot be activated for {} ({})", skill, (Object)player, (Object)result);
                    }
                } else {
                    LOGGER.warn("Skill {} was not found so {} cannot activate it", (Object)msg.skillId(), (Object)player);
                }
            });
        });
    }

    public void handleUpgradeMinionStatPacket(ServerboundUpgradeMinionStatPacket msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Entity entity = player.level().getEntity(msg.entityId());
            if (entity instanceof MinionEntity && ((MinionEntity)entity).getMinionData().map(d -> d.upgradeStat(msg.statId(), (MinionEntity)entity)).orElse(false).booleanValue()) {
                HelperLib.sync((MinionEntity)entity);
            }
        });
    }

    public void handleRequestSkillTreePacket(ServerboundRequestSkillTreePacket msg, IPayloadContext context) {
        context.reply((CustomPacketPayload)ClientboundSkillTreePacket.of(ServerSkillTreeData.instance().getConfigurations()));
    }
}

