/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.items.BlessableItem;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.awt.Color;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BlessingRecipeCategory
implements IRecipeCategory<BlessableItem.Recipe> {
    @NotNull
    private final IDrawable background;
    @NotNull
    private final IDrawable icon;

    public BlessingRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(VResourceLocation.mod("textures/gui/blessing_recipe_jei.png"), 0, 0, 83, 49).setTextureSize(83, 49).addPadding(10, 20, 20, 20).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ALTAR_CLEANSING.get()));
    }

    @NotNull
    public RecipeType<BlessableItem.Recipe> getRecipeType() {
        return VampirismJEIPlugin.BLESSING;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"text.vampirism.blessing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw( @NotNull BlessableItem.Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        if (recipe.enhanced()) {
            Minecraft minecraft = Minecraft.getInstance();
            graphics.drawString(minecraft.font, (Component)Component.translatable((String)"gui.vampirism.skill_required"), 15, 52, Color.gray.getRGB(), false);
            Font font = minecraft.font;
            MutableComponent mutableComponent = ((ISkill)HunterSkills.ENHANCED_BLESSING.get()).getName();
            Objects.requireNonNull(minecraft.font);
            graphics.drawString(font, (Component)mutableComponent, 15, 52 + 9 + 2, Color.gray.getRGB(), false);
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder,  @NotNull BlessableItem.Recipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 27).addItemStack(recipe.input().getDefaultInstance());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 27).addItemStack(recipe.output().getDefaultInstance());
    }
}

