/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.oil;

import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.items.oil.WeaponOil;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectWeaponOil
extends WeaponOil {
    @NotNull
    private final Holder<MobEffect> effect;
    @NotNull
    private final Supplier<Integer> effectDuration;

    public EffectWeaponOil(@NotNull Holder<MobEffect> effect, @NotNull Supplier<Integer> effectDuration, int maxDuration) {
        super(0, maxDuration);
        this.effect = Objects.requireNonNull(effect);
        this.effectDuration = Objects.requireNonNull(effectDuration);
    }

    public EffectWeaponOil(@NotNull Holder<MobEffect> effect, int effectDuration, int maxDuration) {
        this(effect, () -> effectDuration, maxDuration);
    }

    @Override
    public int getColor() {
        return ((MobEffect)this.effect.value()).getColor();
    }

    @NotNull
    public MobEffect getEffect() {
        return (MobEffect)this.effect.value();
    }

    @NotNull
    public MobEffectInstance getEffectInstance() {
        return new MobEffectInstance(this.effect, this.effectDuration.get().intValue());
    }

    @Override
    public float onHit(ItemStack stack, float amount, IWeaponOil oil, @NotNull LivingEntity target, LivingEntity source) {
        target.addEffect(this.getEffectInstance());
        return 0.0f;
    }

    @Override
    public void getDescription(ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltips) {
        tooltips.add((Component)Component.empty());
        tooltips.add((Component)Component.translatable((String)"text.vampirism.oil.effect_on_hit").withStyle(ChatFormatting.DARK_PURPLE));
        tooltips.add(this.getEffectDescriptionWithDash(this.getEffectInstance(), context));
    }

    @NotNull
    private Component getEffectDescriptionWithDash(@NotNull MobEffectInstance instance, @Nullable Item.TooltipContext context) {
        MutableComponent component = Component.translatable((String)instance.getDescriptionId());
        if (instance.getAmplifier() > 0) {
            component = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.translatable((String)("potion.potency." + instance.getAmplifier()))});
        }
        if (instance.getDuration() > 20 && context != null) {
            component = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{component, MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)1.0f, (float)context.tickRate())});
        }
        return Component.literal((String)"- ").append((Component)component).withStyle(this.getEffect().getCategory().getTooltipFormatting());
    }
}

