/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.component;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.components.IContainedProjectiles;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class ContainedProjectiles
implements IContainedProjectiles {
    public static final ContainedProjectiles EMPTY = new ContainedProjectiles(List.of());
    public static final Codec<ContainedProjectiles> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.CODEC.listOf().fieldOf("contents").forGetter(ContainedProjectiles::getProjectiles)).apply((Applicative)inst, ContainedProjectiles::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ContainedProjectiles> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), ContainedProjectiles::getProjectiles, ContainedProjectiles::new);
    private final List<ItemStack> contents;

    public static ContainedProjectiles of(List<ItemStack> contents) {
        return new ContainedProjectiles(contents);
    }

    private ContainedProjectiles(List<ItemStack> contents) {
        this.contents = contents;
    }

    @Override
    public List<ItemStack> getProjectiles() {
        return Lists.transform(this.contents, ItemStack::copy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContainedProjectiles) {
            ContainedProjectiles other = (ContainedProjectiles)obj;
            return ItemStack.listMatches(this.contents, other.contents);
        }
        return false;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.contents);
    }
}

