/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.blockentity.TentBlockEntity;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TentItem
extends Item {
    private final boolean spawner;

    public static boolean placeAt(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull Direction dir, boolean force, boolean spawner) {
        boolean flag;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int x1 = x + (dir == Direction.SOUTH ? 1 : (dir == Direction.NORTH ? -1 : 0));
        int z1 = z + (dir == Direction.WEST ? 1 : (dir == Direction.EAST ? -1 : 0));
        int x2 = x + (dir == Direction.WEST ? -1 : (dir == Direction.NORTH ? -1 : 1));
        int z2 = z + (dir == Direction.SOUTH || dir == Direction.WEST ? 1 : -1);
        int x3 = x + (dir == Direction.WEST ? -1 : (dir == Direction.EAST ? 1 : 0));
        int z3 = z + (dir == Direction.SOUTH ? 1 : (dir == Direction.NORTH ? -1 : 0));
        Block tent = (Block)ModBlocks.TENT.get();
        Block main = (Block)ModBlocks.TENT_MAIN.get();
        BlockState mainState = main.defaultBlockState();
        if ((force || TentItem.canPlaceAt(mainState, tent, world, x, y, z) && TentItem.canPlaceAt(mainState, tent, world, x1, y, z1) && TentItem.canPlaceAt(mainState, tent, world, x2, y, z2) && TentItem.canPlaceAt(mainState, tent, world, x3, y, z3)) && (flag = world.setBlock(pos, (BlockState)main.defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir.getOpposite()), 3))) {
            BlockEntity tile;
            world.setBlock(new BlockPos(x1, y, z1), (BlockState)((BlockState)tent.defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir)).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(1)), 3);
            world.setBlock(new BlockPos(x2, y, z2), (BlockState)((BlockState)tent.defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir)).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(2)), 3);
            world.setBlock(new BlockPos(x3, y, z3), (BlockState)((BlockState)tent.defaultBlockState().setValue((Property)TentBlock.FACING, (Comparable)dir.getOpposite())).setValue((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(3)), 3);
            if (spawner && (tile = world.getBlockEntity(pos)) instanceof TentBlockEntity) {
                ((TentBlockEntity)tile).setSpawn(true);
            }
            return true;
        }
        return false;
    }

    private static boolean canPlaceAt(@NotNull BlockState state, @NotNull Block block, @NotNull LevelAccessor world, int x, int y, int z) {
        return state.canSurvive((LevelReader)world, new BlockPos(x, y, z));
    }

    public TentItem(boolean spawner) {
        super(new Item.Properties());
        this.spawner = spawner;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (this.spawner) {
            tooltip.add((Component)Component.translatable((String)"tile.vampirism.tent.spawner").withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        if (ctx.getClickedFace() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.getItemInHand();
        Player player = ctx.getPlayer();
        Direction dir = player == null ? Direction.NORTH : Direction.fromYRot((double)ctx.getPlayer().getYRot());
        boolean flag = TentItem.placeAt((LevelAccessor)ctx.getLevel(), ctx.getClickedPos().above(), dir, false, false);
        if (flag) {
            BlockEntity tile = ctx.getLevel().getBlockEntity(ctx.getClickedPos().above());
            if (tile instanceof TentBlockEntity && this.spawner) {
                ((TentBlockEntity)tile).setSpawn(true);
            }
            if (player == null || !player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }
}

