/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.core.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterIntelItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int level;
    private Component tooltip;
    private String descriptionId;

    @NotNull
    public static HunterIntelItem getIntelForExactlyLevel(int level) {
        return HunterIntelItem.getIntelForLevel(level - 5);
    }

    @NotNull
    public static HunterIntelItem getIntelForLevel(int level) {
        return switch (level) {
            case 0 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_0.get());
            case 1 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_1.get());
            case 2 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_2.get());
            case 3 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_3.get());
            case 4 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_4.get());
            case 5 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_5.get());
            case 6 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_6.get());
            case 7 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_7.get());
            case 8 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_8.get());
            case 9 -> (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_9.get());
            default -> {
                LOGGER.warn("HunterIntel of level {} does not exist", (Object)level);
                yield (HunterIntelItem)((Object)ModItems.HUNTER_INTEL_9.get());
            }
        };
    }

    public HunterIntelItem(int level) {
        super(new Item.Properties());
        this.level = level;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flagIn) {
        if (this.tooltip == null) {
            this.tooltip = Component.translatable((String)"text.vampirism.for_up_to_level").append((Component)Component.literal((String)(": " + (this.level + 5)))).withStyle(ChatFormatting.RED);
        }
        tooltips.add(this.tooltip);
    }

    @NotNull
    public Component getCustomName() {
        return Component.translatable((String)this.getOrCreateDescriptionId()).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"text.vampirism.for_up_to_level").append((Component)Component.literal((String)(" " + (this.level + 5)))));
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = super.getOrCreateDescriptionId().replaceAll("_\\d", "");
        }
        return this.descriptionId;
    }
}

