/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.HunterArmorItem;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterCoatItem
extends HunterArmorItem
implements IItemWithTier {
    @NotNull
    private final IItemWithTier.TIER tier;

    @Nullable
    public static IItemWithTier.TIER isFullyEquipped(@NotNull Player player) {
        int minLevel = 1000;
        for (ItemStack stack : player.getInventory().armor) {
            if (stack.isEmpty() || !(stack.getItem() instanceof HunterCoatItem)) {
                return null;
            }
            minLevel = Math.min(minLevel, ((HunterCoatItem)stack.getItem()).getVampirismTier().ordinal());
        }
        return IItemWithTier.TIER.values()[minLevel];
    }

    public HunterCoatItem(@NotNull Holder<ArmorMaterial> material, @NotNull ArmorItem.Type type, @NotNull IItemWithTier.TIER tier) {
        Item.Properties properties = new Item.Properties();
        super(material, type, properties.durability(type.getDurability(switch (tier) {
            default -> throw new MatchException(null, null);
            case IItemWithTier.TIER.NORMAL -> 15;
            case IItemWithTier.TIER.ENHANCED -> 20;
            case IItemWithTier.TIER.ULTIMATE -> 25;
        })));
        this.tier = tier;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

