/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ModDisplayItemGenerator;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.HunterSwordItem;
import de.teamlapen.vampirism.util.ToolMaterial;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterAxeItem
extends HunterSwordItem
implements IItemWithTier,
ModDisplayItemGenerator.CreativeTabItemProvider {
    public static final ToolMaterial.Tiered NORMAL = new ToolMaterial.Tiered(IItemWithTier.TIER.NORMAL, (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 250, 3.6f, 7.0f, 14, () -> Ingredient.of((TagKey)Tags.Items.INGOTS_IRON));
    public static final ToolMaterial.Tiered ENHANCED = new ToolMaterial.Tiered(IItemWithTier.TIER.ENHANCED, (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1561, 3.6f, 7.0f, 14, () -> Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND));
    public static final ToolMaterial.Tiered ULTIMATE = new ToolMaterial.Tiered(IItemWithTier.TIER.ULTIMATE, (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 2031, 3.6f, 7.0f, 14, () -> Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE));
    private final IItemWithTier.TIER tier;

    public HunterAxeItem(ToolMaterial.Tiered material) {
        super(material, 3, -2.9f, new Item.Properties());
        this.tier = material.getTier();
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        tooltip.add((Component)Component.translatable((String)"text.vampirism.deals_more_damage_to", (Object[])new Object[]{Math.round((this.getVampireMult() - 1.0f) * 100.0f), VReference.VAMPIRE_FACTION.getNamePlural()}).withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    @Override
    public void generateCreativeTab(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        HolderLookup.RegistryLookup enchantments = parameters.holders().lookupOrThrow(Registries.ENCHANTMENT);
        output.accept(this.getEnchantedStack((HolderLookup.RegistryLookup<Enchantment>)enchantments));
    }

    @Override
    public float getDamageMultiplierForFaction(@NotNull ItemStack stack) {
        return this.getVampireMult();
    }

    @NotNull
    public ItemStack getEnchantedStack(HolderLookup.RegistryLookup<Enchantment> enchantments) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.enchant((Holder)enchantments.getOrThrow(Enchantments.KNOCKBACK), this.getKnockback());
        return stack;
    }

    @Override
    public int getMinLevel(@NotNull ItemStack stack) {
        return this.getMinLevel();
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return false;
    }

    private int getKnockback() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE -> 4;
            case IItemWithTier.TIER.ENHANCED -> 3;
            default -> 2;
        };
    }

    private int getMinLevel() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE -> 8;
            case IItemWithTier.TIER.ENHANCED -> 6;
            default -> 4;
        };
    }

    private float getVampireMult() {
        return switch (this.tier) {
            case IItemWithTier.TIER.ULTIMATE, IItemWithTier.TIER.ENHANCED -> 1.3f;
            default -> 1.2f;
        };
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

