/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.blocks.AlchemicalFireBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.util.DamageHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrossbowArrowItem
extends ArrowItem
implements IVampirismCrossbowArrow<CrossbowArrowEntity> {
    private final EnumArrowType type;

    public CrossbowArrowItem(EnumArrowType type) {
        super(new Item.Properties());
        this.type = type;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        switch (this.type.ordinal()) {
            case 2: {
                components.add((Component)Component.translatable((String)"item.vampirism.crossbow_arrow_spitfire.tooltip").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 1: {
                components.add((Component)Component.translatable((String)"item.vampirism.crossbow_arrow_vampire_killer.tooltip").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 3: {
                components.add((Component)Component.translatable((String)"item.vampirism.crossbow_arrow_teleport.tooltip").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    @NotNull
    public AbstractArrow createArrow(Level pLevel, ItemStack pStack, LivingEntity pShooter, @Nullable ItemStack weapon) {
        CrossbowArrowEntity arrowEntity = new CrossbowArrowEntity(pLevel, pShooter, pStack, weapon);
        arrowEntity.setEffectsFromItem(pStack);
        arrowEntity.setBaseDamage(this.type.baseDamage * (Double)VampirismConfig.BALANCE.crossbowDamageMult.get());
        if (this.type == EnumArrowType.SPITFIRE) {
            arrowEntity.igniteForSeconds(100.0f);
        }
        if (pShooter instanceof Player) {
            arrowEntity.pickup = this.type == EnumArrowType.NORMAL ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
        }
        return arrowEntity;
    }

    @NotNull
    public AbstractArrow createArrow(@NotNull Level level, @NotNull ItemStack stack, @NotNull Position position, @Nullable ItemStack weapon) {
        CrossbowArrowEntity arrowEntity = new CrossbowArrowEntity(level, position.x(), position.y(), position.z(), stack, weapon);
        arrowEntity.setEffectsFromItem(stack);
        arrowEntity.setBaseDamage(this.type.baseDamage * (Double)VampirismConfig.BALANCE.crossbowDamageMult.get());
        if (this.type == EnumArrowType.SPITFIRE) {
            arrowEntity.igniteForSeconds(100.0f);
        }
        arrowEntity.pickup = this.type == EnumArrowType.NORMAL ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
        return arrowEntity;
    }

    public EnumArrowType getType() {
        return this.type;
    }

    @Override
    public boolean isCanBeInfinite() {
        return this.type == EnumArrowType.NORMAL || (Boolean)VampirismConfig.BALANCE.allowInfiniteSpecialArrows.get() != false;
    }

    @Override
    public void onHitBlock(ItemStack arrow, @NotNull BlockPos blockPos, IEntityCrossbowArrow arrowEntity, @Nullable Entity shootingEntity) {
        CrossbowArrowEntity entity = (CrossbowArrowEntity)arrowEntity;
        switch (this.type.ordinal()) {
            case 2: {
                for (int dx = -1; dx < 2; ++dx) {
                    for (int dy = -2; dy < 2; ++dy) {
                        for (int dz = -1; dz < 2; ++dz) {
                            BlockPos pos = blockPos.offset(dx, dy, dz);
                            BlockState blockState = entity.getCommandSenderWorld().getBlockState(pos);
                            if (!blockState.canBeReplaced() || !entity.getCommandSenderWorld().getBlockState(pos.below()).isFaceSturdy((BlockGetter)entity.getCommandSenderWorld(), pos.below(), Direction.UP) || entity.getRNG().nextInt(4) == 0) continue;
                            entity.getCommandSenderWorld().setBlockAndUpdate(pos, ((AlchemicalFireBlock)((Object)ModBlocks.ALCHEMICAL_FIRE.get())).defaultBlockState());
                        }
                    }
                }
                break;
            }
            case 3: {
                if (shootingEntity == null || shootingEntity.level().isClientSide || !shootingEntity.isAlive()) break;
                if (shootingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)shootingEntity;
                    if (!player.connection.getConnection().isConnected() || player.level() != entity.level() || player.isSleeping()) break;
                    if (player.isPassenger()) {
                        player.stopRiding();
                    }
                    player.teleportTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                    player.fallDistance = 0.0f;
                    DamageHandler.hurtVanilla((Entity)player, DamageSources::fall, 1.0f);
                    break;
                }
                shootingEntity.teleportTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                shootingEntity.fallDistance = 0.0f;
            }
        }
    }

    @Override
    public void onHitEntity(ItemStack arrow, LivingEntity entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        float max;
        if (this.type == EnumArrowType.VAMPIRE_KILLER && entity instanceof IVampireMob && (max = entity.getMaxHealth()) < (float)((Integer)VampirismConfig.BALANCE.arrowVampireKillerMaxHealth.get()).intValue()) {
            DamageHandler.hurtVanilla((Entity)entity, damageSources -> damageSources.arrow((AbstractArrow)arrowEntity, shootingEntity), max);
        }
    }

    public static enum EnumArrowType implements StringRepresentable
    {
        NORMAL("normal", 2.0, -1),
        VAMPIRE_KILLER("vampire_killer", 0.5, -8781709),
        SPITFIRE("spitfire", 0.5, -56815),
        TELEPORT("teleport", 0.5, -16036542);

        public final int color;
        final String name;
        final double baseDamage;

        private EnumArrowType(String name, double baseDamage, int color) {
            this.name = name;
            this.baseDamage = baseDamage;
            this.color = color;
        }

        @NotNull
        public String getName() {
            return this.getSerializedName();
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

