/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.items.HunterArmorItem;
import de.teamlapen.vampirism.mixin.accessor.ArmorItemAccessor;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorOfSwiftnessItem
extends HunterArmorItem
implements IItemWithTier {
    @NotNull
    private final IItemWithTier.TIER tier;

    private static float getSpeedReduction(IItemWithTier.TIER tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case IItemWithTier.TIER.NORMAL -> 0.035f;
            case IItemWithTier.TIER.ENHANCED -> 0.075f;
            case IItemWithTier.TIER.ULTIMATE -> 0.1f;
        };
    }

    public ArmorOfSwiftnessItem(@NotNull Holder<ArmorMaterial> material, @NotNull ArmorItem.Type type, @NotNull IItemWithTier.TIER tier) {
        Item.Properties properties = new Item.Properties();
        super(material, type, properties.durability(type.getDurability(switch (tier) {
            default -> throw new MatchException(null, null);
            case IItemWithTier.TIER.NORMAL -> 5;
            case IItemWithTier.TIER.ENHANCED -> 6;
            case IItemWithTier.TIER.ULTIMATE -> 7;
        })));
        this.tier = tier;
        Supplier defaultModifiers = ((ArmorItemAccessor)((Object)this)).getDefaultModifiers();
        defaultModifiers = Suppliers.compose(modifiers -> modifiers.withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(VResourceLocation.mod("armor_modifier_" + type.getSerializedName()), (double)ArmorOfSwiftnessItem.getSpeedReduction(tier), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot())), () -> defaultModifiers.get());
        ((ArmorItemAccessor)((Object)this)).setDefaultModifiers((java.util.function.Supplier<ItemAttributeModifiers>)defaultModifiers);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity.tickCount % 45 == 3 && pSlotId >= 36 && pSlotId <= 39 && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (this.getType() == ArmorItem.Type.CHESTPLATE) {
                boolean flag = true;
                int boost = Integer.MAX_VALUE;
                for (ItemStack stack : player.getInventory().armor) {
                    if (!stack.isEmpty() && stack.getItem() instanceof ArmorOfSwiftnessItem) {
                        int b = this.getJumpBoost(this.getVampirismTier());
                        if (b >= boost) continue;
                        boost = b;
                        continue;
                    }
                    flag = false;
                    break;
                }
                if (flag && boost > -1) {
                    player.addEffect(new MobEffectInstance(MobEffects.JUMP, 50, boost, false, false));
                }
            }
        }
    }

    private int getJumpBoost(@NotNull IItemWithTier.TIER tier) {
        return switch (tier) {
            case IItemWithTier.TIER.ULTIMATE -> 1;
            case IItemWithTier.TIER.ENHANCED -> 0;
            default -> -1;
        };
    }

    private String getTextureLocationLeather(EquipmentSlot slot) {
        return String.format("minecraft:textures/models/armor/leather_layer_%d.png", slot == EquipmentSlot.LEGS ? 2 : 1);
    }
}

