/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.BooleanDataSlot;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.inventory.WeaponTableCraftingSlot;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class WeaponTableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess worldPos;
    @NotNull
    private final HunterPlayer hunterPlayer;
    @NotNull
    private final Player player;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 4, 4);
    private final ResultContainer craftResult = new ResultContainer();
    private final BooleanDataSlot missingLava = new BooleanDataSlot();
    private final RecipeManager.CachedCheck<CraftingInput, IWeaponTableRecipe> quickCheck;

    public WeaponTableMenu(int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType)ModMenus.WEAPON_TABLE.get(), id);
        this.worldPos = worldPosCallable;
        this.hunterPlayer = HunterPlayer.get(playerInventory.player);
        this.player = playerInventory.player;
        this.addSlot(new WeaponTableCraftingSlot(playerInventory.player, this.craftMatrix, (Container)this.craftResult, 0, 144, 46, worldPosCallable));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.addSlot(new Slot((Container)this.craftMatrix, j + i * 4, 34 + j * 19, 16 + i * 19));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + k * 9 + 9, 18 + i1 * 18, 107 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 18 + l * 18, 165));
        }
        this.addDataSlot(this.missingLava);
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get()));
        this.slotsChanged((Container)this.craftMatrix);
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, @NotNull Slot slotIn) {
        return slotIn.container != this.craftResult && super.canTakeItemForPickAll(stack, slotIn);
    }

    public boolean hasLava() {
        return (Boolean)this.worldPos.evaluate((world, blockPos) -> (Integer)world.getBlockState(blockPos).getValue((Property)WeaponTableBlock.LAVA) > 0, (Object)false);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemStackCopy = itemstack1.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, 17, 53, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemStackCopy);
            } else if (index >= 17 && index < 44 ? !this.moveItemStackTo(itemstack1, 44, 53, false) : (index >= 44 && index < 53 ? !this.moveItemStackTo(itemstack1, 17, 44, false) : !this.moveItemStackTo(itemstack1, 17, 53, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStackCopy.getCount() == itemstack1.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemStackCopy;
    }

    public boolean isMissingLava() {
        return this.missingLava.getB();
    }

    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        this.worldPos.execute((world, pos) -> {
            this.clearContainer(playerIn, (Container)this.craftMatrix);
            for (int i = 0; i < this.craftMatrix.getContainerSize(); ++i) {
                ItemStack itemstack = this.craftMatrix.removeItemNoUpdate(i);
                if (itemstack.isEmpty()) continue;
                playerIn.drop(itemstack, false);
            }
            this.missingLava.set(false);
        });
    }

    public void slotsChanged(@NotNull Container inventoryIn) {
        this.worldPos.execute((world, pos) -> this.slotChangedCraftingGrid((Level)world, this.player, this.hunterPlayer, CraftingInput.of((int)this.craftMatrix.getWidth(), (int)this.craftMatrix.getHeight(), (List)this.craftMatrix.getItems()), this.craftResult));
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return WeaponTableMenu.stillValid((ContainerLevelAccess)this.worldPos, (Player)playerIn, (Block)((Block)ModBlocks.WEAPON_TABLE.get()));
    }

    public Optional<List<ISkill<IHunterPlayer>>> missingSkills() {
        return this.worldPos.evaluate((world, pos) -> {
            Optional recipeFor = this.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)this.craftMatrix.getWidth(), (int)this.craftMatrix.getHeight(), (List)this.craftMatrix.getItems()), world);
            return recipeFor.stream().flatMap(s -> ((IWeaponTableRecipe)s.value()).getRequiredSkills().stream()).filter(s -> !this.hunterPlayer.getSkillHandler().isSkillEnabled((ISkill<?>)s)).toList();
        });
    }

    private void slotChangedCraftingGrid(@NotNull Level worldIn, Player playerIn, @NotNull HunterPlayer hunter, @NotNull CraftingInput craftMatrixIn, @NotNull ResultContainer craftResultIn) {
        if (!worldIn.isClientSide && playerIn instanceof ServerPlayer) {
            RecipeHolder recipe;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            Optional optional = this.quickCheck.getRecipeFor((RecipeInput)craftMatrixIn, worldIn);
            this.missingLava.set(false);
            craftResultIn.setItem(0, ItemStack.EMPTY);
            if (optional.isPresent() && (craftResultIn.setRecipeUsed(worldIn, serverPlayer, recipe = (RecipeHolder)optional.get()) || ModList.get().isLoaded("fastbench")) && ((IWeaponTableRecipe)recipe.value()).getRequiredLevel() <= hunter.getLevel() && Helper.areSkillsEnabled(hunter.getSkillHandler(), ((IWeaponTableRecipe)recipe.value()).getRequiredSkills())) {
                this.worldPos.execute((world, pos) -> {
                    if ((Integer)world.getBlockState(pos).getValue((Property)WeaponTableBlock.LAVA) >= ((IWeaponTableRecipe)recipe.value()).getRequiredLavaUnits()) {
                        craftResultIn.setItem(0, ((IWeaponTableRecipe)recipe.value()).assemble(craftMatrixIn, (HolderLookup.Provider)world.registryAccess()));
                    } else {
                        this.missingLava.set(true);
                    }
                });
            }
            this.broadcastChanges();
            serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, craftResultIn.getItem(0)));
        }
    }

    public static class Factory
    implements IContainerFactory<WeaponTableMenu> {
        @NotNull
        public WeaponTableMenu create(int windowId, @NotNull Inventory inv, @NotNull RegistryFriendlyByteBuf data) {
            BlockPos pos = data.readBlockPos();
            return new WeaponTableMenu(windowId, inv, ContainerLevelAccess.create((Level)inv.player.level(), (BlockPos)pos));
        }
    }
}

