/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponTableCraftingSlot
extends Slot {
    private final Player player;
    private final ContainerLevelAccess worldPos;
    private final CraftingContainer craftMatrix;
    private int amountCrafted = 0;

    public WeaponTableCraftingSlot(Player player, CraftingContainer craftingInventory, @NotNull Container inventoryIn, int index, int xPosition, int yPosition, ContainerLevelAccess worldPosCallable) {
        super(inventoryIn, index, xPosition, yPosition);
        this.player = player;
        this.craftMatrix = craftingInventory;
        this.worldPos = worldPosCallable;
    }

    public boolean mayPlace(@Nullable ItemStack stack) {
        return false;
    }

    public void onTake(@NotNull Player playerIn, @NotNull ItemStack stack) {
        this.checkTakeAchievements(stack);
        int lava = (Integer)this.worldPos.evaluate((world, blockPos) -> {
            if (world.getBlockState(blockPos).getBlock() instanceof WeaponTableBlock) {
                return (Integer)world.getBlockState(blockPos).getValue((Property)WeaponTableBlock.LAVA);
            }
            return 0;
        }, (Object)0);
        IWeaponTableRecipe recipe = this.findMatchingRecipe(playerIn, HunterPlayer.get(playerIn), lava);
        if (recipe != null && recipe.getRequiredLavaUnits() > 0) {
            this.worldPos.execute((world, pos) -> {
                int remainingLava = Math.max(0, lava - recipe.getRequiredLavaUnits());
                BlockState state = world.getBlockState(pos);
                if (state.getBlock() instanceof WeaponTableBlock) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WeaponTableBlock.LAVA, (Comparable)Integer.valueOf(remainingLava)));
                }
            });
        }
        CommonHooks.setCraftingPlayer((Player)playerIn);
        NonNullList remaining = playerIn.level().getRecipeManager().getRemainingItemsFor((RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get(), (RecipeInput)CraftingInput.of((int)this.craftMatrix.getWidth(), (int)this.craftMatrix.getHeight(), (List)this.craftMatrix.getItems()), playerIn.level());
        CommonHooks.setCraftingPlayer(null);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack itemstack = this.craftMatrix.getItem(i);
            ItemStack itemstack1 = (ItemStack)remaining.get(i);
            if (!itemstack.isEmpty()) {
                this.craftMatrix.removeItem(i, 1);
                itemstack = this.craftMatrix.getItem(i);
            }
            if (itemstack1.isEmpty()) continue;
            if (itemstack.isEmpty()) {
                this.craftMatrix.setItem(i, itemstack1);
                continue;
            }
            if (ItemStack.isSameItem((ItemStack)itemstack, (ItemStack)itemstack1) && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)itemstack1)) {
                itemstack1.grow(itemstack.getCount());
                this.craftMatrix.setItem(i, itemstack1);
                continue;
            }
            if (this.player.getInventory().add(itemstack1)) continue;
            this.player.drop(itemstack1, false);
        }
        this.worldPos.execute((world, pos) -> {
            if (recipe != null && !world.isClientSide) {
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)ModSounds.WEAPON_TABLE_CRAFTING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        });
        playerIn.awardStat((ResourceLocation)ModStats.WEAPON_TABLE.get());
    }

    @NotNull
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void checkTakeAchievements(@NotNull ItemStack stack) {
        if (this.amountCrafted > 0) {
            stack.onCraftedBy(this.player.getCommandSenderWorld(), this.player, this.amountCrafted);
        }
        this.amountCrafted = 0;
    }

    @Nullable
    protected IWeaponTableRecipe findMatchingRecipe(@NotNull Player playerIn, @NotNull IFactionPlayer<IHunterPlayer> factionPlayer, int lava) {
        Optional optional = playerIn.getCommandSenderWorld().getRecipeManager().getRecipeFor((RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get(), (RecipeInput)CraftingInput.of((int)this.craftMatrix.getWidth(), (int)this.craftMatrix.getHeight(), (List)this.craftMatrix.getItems()), playerIn.getCommandSenderWorld());
        if (optional.isPresent()) {
            IWeaponTableRecipe recipe = (IWeaponTableRecipe)((RecipeHolder)optional.get()).value();
            if (factionPlayer.getLevel() >= recipe.getRequiredLevel() && lava >= recipe.getRequiredLavaUnits() && Helper.areSkillsEnabled(factionPlayer.getSkillHandler(), recipe.getRequiredSkills())) {
                return recipe;
            }
        }
        return null;
    }

    protected void onQuickCraft(@NotNull ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.checkTakeAchievements(stack);
    }
}

