/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.inventory.VampirismContainerMenu;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class VampireBeaconMenu
extends VampirismContainerMenu {
    private final Container beacon = new SimpleContainer(this, 1){

        public boolean canPlaceItem(int pIndex, ItemStack pStack) {
            return pStack.is(ModTags.Items.VAMPIRE_BEACON_PAYMENT_ITEM);
        }

        public int getMaxStackSize() {
            return 1;
        }
    };
    private final PaymentSlot paymentSlot;
    private final ContainerData beaconData;
    private final ContainerLevelAccess access;

    public VampireBeaconMenu(int pContainerId, Container container) {
        this(pContainerId, container, (ContainerData)new SimpleContainerData(4), ContainerLevelAccess.NULL);
    }

    public VampireBeaconMenu(int pContainerId, Container container, ContainerData beaconData, ContainerLevelAccess pLevelAccess) {
        super((MenuType)ModMenus.VAMPIRE_BEACON.get(), pContainerId, 1);
        this.beaconData = beaconData;
        this.access = pLevelAccess;
        this.paymentSlot = new PaymentSlot(this.beacon, 0, 136, 110);
        this.addSlot(this.paymentSlot);
        this.addDataSlots(beaconData);
        this.addPlayerSlots(container, 36, 137);
    }

    public void removed(@NotNull Player pPlayer) {
        ItemStack itemStack;
        super.removed(pPlayer);
        if (pPlayer.level().isClientSide && !(itemStack = this.paymentSlot.remove(this.paymentSlot.getMaxStackSize())).isEmpty()) {
            pPlayer.drop(itemStack, false);
        }
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return VampireBeaconMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.VAMPIRE_BEACON.get()));
    }

    public void setData(int pId, int pData) {
        super.setData(pId, pData);
        this.broadcastChanges();
    }

    public int getLevels() {
        return this.beaconData.get(0);
    }

    @Nullable
    public Holder<MobEffect> getPrimaryEffect() {
        return BeaconMenu.decodeEffect((int)this.beaconData.get(1));
    }

    public int getAmplifier() {
        return this.beaconData.get(2);
    }

    public boolean isUpgraded() {
        return this.beaconData.get(3) > 0;
    }

    public void updateEffects(Optional<Holder<MobEffect>> primaryEffect, Optional<Integer> amplifier) {
        if (this.paymentSlot.hasItem()) {
            this.beaconData.set(1, primaryEffect.map(BeaconMenu::encodeEffect).orElse(-1).intValue());
            this.beaconData.set(2, amplifier.orElse(0).intValue());
            this.paymentSlot.remove(1);
            this.access.execute(Level::blockEntityChanged);
        }
    }

    public boolean hasPayment() {
        return !this.beacon.getItem(0).isEmpty();
    }

    public static class PaymentSlot
    extends Slot {
        public PaymentSlot(Container pContainer, int pIndex, int pX, int pY) {
            super(pContainer, pIndex, pX, pY);
        }

        public boolean mayPlace(ItemStack pStack) {
            return pStack.is(ModTags.Items.VAMPIRE_BEACON_PAYMENT_ITEM);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

