/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.network.ServerboundSelectMinionTaskPacket;
import de.teamlapen.vampirism.network.ServerboundToggleMinionTaskLock;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.IContainerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinionContainer
extends InventoryContainerMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final MinionEntity<?> minionEntity;
    @NotNull
    private final @NotNull IMinionTask<?, ?> @NotNull [] availableTasks;
    @Nullable
    private final IMinionTask<?, ?> previousTask;
    private final boolean previousTaskLocked;
    private final int extraSlots;
    @Nullable
    private IMinionTask<?, ?> taskToActivate;
    private boolean taskLocked;

    @Nullable
    public static MinionContainer create(int id, @NotNull Inventory playerInventory, @NotNull MinionEntity<?> minionEntity, @NotNull ILordPlayer lord) {
        Optional<IMinionInventory> minionInv = minionEntity.getInventory();
        return minionInv.map(inv -> new MinionContainer(id, playerInventory, lord, minionEntity, (Container)inv, inv.getAvailableSize(), MinionContainer.createSelectors(minionEntity, inv.getAvailableSize()))).orElse(null);
    }

    private static InventoryContainerMenu.SelectorInfo @NotNull [] createSelectors(@NotNull MinionEntity<?> minionEntity, int extraSlots) {
        InventoryContainerMenu.SelectorInfo[] slots = new InventoryContainerMenu.SelectorInfo[6 + extraSlots];
        slots[0] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.MAINHAND).and(stack -> stack.canEquip(EquipmentSlot.MAINHAND, (LivingEntity)minionEntity)), 7, 60, false, 1, null);
        slots[1] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.OFFHAND).and(stack -> stack.canEquip(EquipmentSlot.OFFHAND, (LivingEntity)minionEntity) || stack.getUseAnimation() == UseAnim.DRINK || stack.getUseAnimation() == UseAnim.EAT), 7, 78, false, 5, null);
        slots[2] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.FEET).and(stack -> stack.canEquip(EquipmentSlot.FEET, (LivingEntity)minionEntity)), 81, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS));
        slots[3] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.LEGS).and(stack -> stack.canEquip(EquipmentSlot.LEGS, (LivingEntity)minionEntity)), 63, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS));
        slots[4] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.CHEST).and(stack -> stack.canEquip(EquipmentSlot.CHEST, (LivingEntity)minionEntity)), 45, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE));
        slots[5] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.HEAD).and(stack -> stack.canEquip(EquipmentSlot.HEAD, (LivingEntity)minionEntity)), 27, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_HELMET));
        assert (extraSlots == 9 || extraSlots == 12 || extraSlots == 15) : "Minion inventory has unexpected size";
        for (int i = 0; i < extraSlots; ++i) {
            slots[6 + i] = new InventoryContainerMenu.SelectorInfo(itemStack -> true, 27 + 18 * (i / 3), 42 + 18 * (i % 3));
        }
        return slots;
    }

    public MinionContainer(int id, @NotNull Inventory playerInventory, @NotNull ILordPlayer lord, @NotNull MinionEntity<?> minionEntity, @NotNull Container inventory, int extraSlots, InventoryContainerMenu.SelectorInfo ... selectorInfos) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModMenus.MINION.get()), id, playerInventory, ContainerLevelAccess.create((Level)minionEntity.level(), (BlockPos)minionEntity.blockPosition()), inventory, selectorInfos);
        this.minionEntity = minionEntity;
        this.extraSlots = extraSlots;
        this.availableTasks = (IMinionTask[])this.minionEntity.getAvailableTasks().stream().filter(task -> task.isAvailable(lord.getLordFaction(), lord)).toArray(IMinionTask[]::new);
        this.minionEntity.setInteractingPlayer(playerInventory.player);
        this.addPlayerSlots(playerInventory, 27, 103);
        this.previousTask = this.minionEntity.getCurrentTask().map(IMinionTask.IMinionTaskDesc::getTask).orElse(null);
        this.previousTaskLocked = this.taskLocked = this.minionEntity.isTaskLocked();
    }

    @Override
    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        if (this.minionEntity.level().isClientSide()) {
            this.sendChanges();
        }
        this.minionEntity.setInteractingPlayer(null);
    }

    @NotNull
    public IMinionTask<?, ?>[] getAvailableTasks() {
        return this.availableTasks;
    }

    public int getExtraSlots() {
        return this.extraSlots;
    }

    @NotNull
    public Optional<IMinionTask<?, ?>> getPreviousTask() {
        return Optional.ofNullable(this.previousTask);
    }

    @NotNull
    public IMinionTask<?, ?> getSelectedTask() {
        return this.taskToActivate != null ? this.taskToActivate : (this.previousTask != null ? this.previousTask : (IMinionTask<Object, Object>)MinionTasks.STAY.get());
    }

    public boolean isTaskLocked() {
        return this.taskLocked;
    }

    public void setTaskLocked(boolean taskLocked) {
        this.taskLocked = taskLocked;
    }

    @Override
    public boolean stillValid(@NotNull Player playerIn) {
        return this.minionEntity.isAlive();
    }

    public void openConfigurationScreen() {
        this.minionEntity.openAppearanceScreen();
    }

    public void openStatsScreen() {
        this.minionEntity.openStatsScreen();
    }

    public void setTaskToActivate(int id) {
        assert (id >= 0 && id < this.availableTasks.length);
        if (id >= 0 && id < this.availableTasks.length) {
            this.taskToActivate = this.availableTasks[id];
        }
    }

    private void sendChanges() {
        if (this.taskToActivate != null && this.taskToActivate != this.previousTask) {
            this.minionEntity.getMinionId().ifPresent(id -> VampirismMod.proxy.sendToServer(new ServerboundSelectMinionTaskPacket((int)id, RegUtil.id(this.taskToActivate))));
        }
        if (this.previousTaskLocked != this.taskLocked) {
            this.minionEntity.getMinionId().ifPresent(id -> VampirismMod.proxy.sendToServer(new ServerboundToggleMinionTaskLock((int)id)));
        }
    }

    public static class Factory
    implements IContainerFactory<MinionContainer> {
        public MinionContainer create(int p_create_1_, Inventory p_create_2_) {
            return (MinionContainer)super.create(p_create_1_, p_create_2_);
        }

        @Nullable
        public MinionContainer create(int windowId, @NotNull Inventory inv, @Nullable RegistryFriendlyByteBuf data) {
            Entity e;
            if (data == null) {
                return null;
            }
            int entityId = data.readVarInt();
            Entity entity = e = inv.player.level() == null ? null : inv.player.level().getEntity(entityId);
            if (!(e instanceof MinionEntity)) {
                LOGGER.error("Cannot find related minion entity {}", (Object)entityId);
                return null;
            }
            FactionPlayerHandler player = FactionPlayerHandler.get(inv.player);
            return MinionContainer.create(windowId, inv, (MinionEntity)e, player);
        }
    }
}

