/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire.action;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IInstantAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.vampire.action.VampireEntityAction;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.NotNull;

public class BatsSpawnEntityAction<T extends PathfinderMob>
extends VampireEntityAction<T>
implements IInstantAction<T> {
    public BatsSpawnEntityAction(@NotNull EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public boolean activate(@NotNull T entity) {
        int amount = (Integer)VampirismConfig.BALANCE.eaBatspawnAmount.get();
        for (int i = 0; i < amount; ++i) {
            Helper.createEntity((EntityType)ModEntities.BLINDING_BAT.get(), entity.getCommandSenderWorld()).ifPresent(e -> {
                e.restrictLiveSpan();
                e.setResting(false);
                e.copyPosition((Entity)entity);
                entity.getCommandSenderWorld().addFreshEntity((Entity)e);
            });
        }
        entity.getCommandSenderWorld().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)ModSounds.BAT_SWARM.get(), SoundSource.PLAYERS, 1.3f, entity.getCommandSenderWorld().random.nextFloat() * 0.2f + 1.3f);
        return true;
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaBatspawnCooldown.get() * 20;
    }
}

