/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public abstract class VampireBaseEntity
extends VampirismEntity
implements IVampireMob,
Npc {
    @NotNull
    protected EnumStrength garlicResist = EnumStrength.NONE;
    protected boolean canSuckBloodFromPlayer = false;
    protected boolean vulnerableToFire = true;
    private SpawnRestriction spawnRestriction = SpawnRestriction.NORMAL;
    private boolean sundamageCache;
    @NotNull
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean dropSoul = false;

    public static boolean spawnPredicateVampire(@NotNull EntityType<? extends VampirismEntity> entityType, @NotNull ServerLevelAccessor world, MobSpawnType spawnReason, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        return world.getDifficulty() != Difficulty.PEACEFUL && (Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)blockPos, (RandomSource)random) || VampireBaseEntity.spawnPredicateVampireFog((LevelAccessor)world, blockPos)) && Mob.checkMobSpawnRules(entityType, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)random);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismEntity.getAttributeBuilder();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.add(ModAttributes.SUNDAMAGE, 7.0);
    }

    public VampireBaseEntity(EntityType<? extends VampireBaseEntity> type, Level world, @Deprecated(forRemoval=true) boolean countAsMonsterForSpawn) {
        super(type, world);
    }

    @Override
    public void aiStep() {
        if (this.tickCount % 40 == 3) {
            this.isGettingGarlicDamage((LevelAccessor)this.level(), true);
        }
        if (this.tickCount % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)this.level(), true);
        }
        if (!this.level().isClientSide) {
            if (this.isGettingSundamage((LevelAccessor)this.level()) && this.isAlive()) {
                double dmg;
                if (((Boolean)VampirismConfig.BALANCE.vpSundamageInstantDeath.get()).booleanValue()) {
                    DamageHandler.hurtModded((Entity)this, ModDamageSources::sunDamage, 1000.0f);
                    this.turnToAsh();
                } else if (this.tickCount % 40 == 11 && (dmg = this.getAttribute((Holder)ModAttributes.SUNDAMAGE).getValue()) > 0.0) {
                    DamageHandler.hurtModded((Entity)this, ModDamageSources::sunDamage, (float)dmg);
                }
            }
            if (this.isGettingGarlicDamage((LevelAccessor)this.level()) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)this.level()), this.tickCount);
            }
        }
        if (!this.level().isClientSide && this.isAlive() && this.isInWater()) {
            this.setAirSupply(300);
            if (this.tickCount % 16 == 4) {
                this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 0));
            }
        }
        super.aiStep();
    }

    private void turnToAsh() {
        if (!this.isAlive()) {
            this.deathTime = 19;
            ModParticles.spawnParticlesServer(this.level(), (ParticleOptions)ParticleTypes.WHITE_ASH, this.getX() + 0.5, this.getY() + (double)this.getBbHeight(), this.getZ() + 0.5, 20, 0.2, (double)this.getBbHeight() * 0.2, 0.2, 0.1);
            ModParticles.spawnParticlesServer(this.level(), (ParticleOptions)ParticleTypes.ASH, this.getX() + 0.5, this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ() + 0.5, 20, 0.2, (double)this.getBbHeight() * 0.2, 0.2, 0.1);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public boolean checkSpawnRules(@NotNull LevelAccessor worldIn, @NotNull MobSpawnType spawnReasonIn) {
        if (this.spawnRestriction.level >= SpawnRestriction.SIMPLE.level) {
            if (this.isGettingSundamage(worldIn, true) || this.isGettingGarlicDamage(worldIn, true) != EnumStrength.NONE) {
                return false;
            }
            if (this.spawnRestriction.level >= SpawnRestriction.NORMAL.level) {
                if ((double)(-worldIn.getPathfindingCostFromLightLevels(this.blockPosition())) < 0.0 && this.random.nextInt(5) != 0) {
                    return false;
                }
                if (this.level().isLoaded(this.blockPosition()) && worldIn instanceof ServerLevel && UtilLib.getStructureStartAt(this.level(), this.blockPosition(), (TagKey<Structure>)StructureTags.VILLAGE).isPresent() && this.getRandom().nextInt(60) != 0) {
                    return false;
                }
                if (this.spawnRestriction.level >= SpawnRestriction.SPECIAL.level && !this.getCanSpawnHereRestricted(worldIn)) {
                    return false;
                }
            }
        }
        return super.checkSpawnRules(worldIn, spawnReasonIn);
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        if (cause.getDirectEntity() instanceof CrossbowArrowEntity && Helper.isHunter(cause.getEntity())) {
            this.dropSoul = true;
        } else if (cause.getDirectEntity() instanceof Player && Helper.isHunter(cause.getDirectEntity())) {
            ItemStack weapon = ((Player)cause.getDirectEntity()).getMainHandItem();
            if (!weapon.isEmpty() && weapon.getItem() instanceof IVampireFinisher) {
                this.dropSoul = true;
            }
        } else {
            this.dropSoul = false;
        }
    }

    @Override
    public boolean doesResistGarlic(@NotNull EnumStrength strength) {
        return !strength.isStrongerThan(this.garlicResist);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        Player player;
        if (this.canSuckBloodFromPlayer && !this.level().isClientSide && this.wantsBlood() && entity instanceof Player && !Helper.isHunter(player = (Player)entity) && !UtilLib.canReallySee((LivingEntity)player, (LivingEntity)this, true)) {
            int amt = VampirePlayer.get(player).onBite(this);
            this.drinkBlood(amt, 0.7f, new DrinkBloodContext((LivingEntity)player));
            VampirePlayer.get(player).tryInfect(this);
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (ItemStack e : living.getArmorSlots()) {
                if (e == null || !(e.getItem() instanceof HunterCoatItem)) continue;
                int j = 1;
                if (((HunterCoatItem)e.getItem()).getVampirismTier().equals((Object)IItemWithTier.TIER.ENHANCED)) {
                    j = 2;
                } else if (((HunterCoatItem)e.getItem()).getVampirismTier().equals((Object)IItemWithTier.TIER.ULTIMATE)) {
                    j = 3;
                }
                if (this.getRandom().nextInt((4 - j) * 2) != 0) continue;
                this.addEffect(new MobEffectInstance(ModEffects.POISON, (int)(20.0 * Math.sqrt(j)), j));
            }
        }
        return super.doHurtTarget(entity);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
         @NotNull BloodDrinkEvent.EntityDrinkBloodEvent event = VampirismEventFactory.fireVampireDrinkBlood(this, amt, saturationMod, useRemaining, drinkContext);
        this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, event.getAmount() * 20));
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @NotNull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    public boolean hurt(@NotNull DamageSource damageSource, float amount) {
        if (this.vulnerableToFire) {
            if (damageSource.is(DamageTypes.IN_FIRE)) {
                return DamageHandler.hurtModded((Entity)this, ModDamageSources::vampireInFire, this.calculateFireDamage(amount));
            }
            if (damageSource.is(DamageTypes.ON_FIRE)) {
                return DamageHandler.hurtModded((Entity)this, ModDamageSources::vampireOnFire, this.calculateFireDamage(amount));
            }
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.level().getProfiler());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.hasEffect((Holder)ModEffects.SUNSCREEN);
    }

    public void setSpawnRestriction(SpawnRestriction r) {
        this.spawnRestriction = r;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, amt * 20));
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    protected float calculateFireDamage(float amount) {
        return amount;
    }

    protected void tickDeath() {
        if (this.deathTime == 19 && !this.level().isClientSide && this.dropSoul && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.level().addFreshEntity((Entity)new SoulOrbEntity(this.level(), this.getX(), this.getY(), this.getZ(), SoulOrbEntity.VARIANT.VAMPIRE));
        }
        super.tickDeath();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    private boolean getCanSpawnHereRestricted(@NotNull LevelAccessor iWorld) {
        boolean vampireBiome = iWorld.getBiome(this.blockPosition()).is(ModTags.Biomes.IS_VAMPIRE_BIOME);
        boolean lowLightLevel = this.isLowLightLevel(iWorld);
        if (lowLightLevel) {
            return true;
        }
        if (!vampireBiome) {
            return false;
        }
        BlockState iblockstate = iWorld.getBlockState(this.blockPosition().below());
        return iblockstate.is(ModTags.Blocks.CURSED_EARTH);
    }

    public static enum SpawnRestriction {
        NONE(0),
        SIMPLE(1),
        NORMAL(2),
        SPECIAL(3);

        final int level;

        private SpawnRestriction(int level) {
            this.level = level;
        }
    }
}

