/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IBasicVampire;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.IEntityFollower;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.ai.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.ai.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.BiteNearbyEntityVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendLeaderGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.FollowAdvancedVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.ai.goals.MoveToBiteableVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.VampireVillage;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicVampireEntity
extends VampireBaseEntity
implements IBasicVampire,
IEntityActionUser,
IEntityFollower {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.defineId(BasicVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(BasicVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MAX_LEVEL = 2;
    private static final int ANGRY_TICKS_PER_ATTACK = 120;
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    @NotNull
    private final EntityActionTier entitytier;
    private int bloodtimer = 100;
    @Nullable
    private IEntityLeader advancedLeader = null;
    private int angryTimer = 0;
    private Goal tasks_avoidHunter;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampireBaseEntity.getAttributeBuilder().add(Attributes.MAX_HEALTH, 1.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, BalanceMobProps.mobProps.VAMPIRE_SPEED);
    }

    public BasicVampireEntity(EntityType<? extends BasicVampireEntity> type, Level world) {
        super(type, world, true);
        this.canSuckBloodFromPlayer = true;
        this.hasArms = true;
        this.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SPECIAL);
        this.entitytier = EntityActionTier.Medium;
        this.entityclass = EntityClassType.getRandomClass(this.getRandom());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<BasicVampireEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("level", this.getEntityLevel());
        nbt.putInt("type", this.getEntityTextureType());
        nbt.putBoolean("attack", this.attack);
        nbt.putInt("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes totem) {
        this.goalSelector.removeGoal(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = true;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.bloodtimer > 0) {
            --this.bloodtimer;
        }
        if (this.angryTimer > 0) {
            --this.angryTimer;
        }
        if (this.tickCount % 9 == 3 && ((Boolean)VampirismConfig.BALANCE.vpFireResistanceReplace.get()).booleanValue() && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            MobEffectInstance fireResistance = this.removeEffectNoUpdate(MobEffects.FIRE_RESISTANCE);
            assert (fireResistance != null);
            this.onEffectRemoved(fireResistance);
            this.addEffect(new MobEffectInstance(ModEffects.FIRE_PROTECTION, fireResistance.getDuration(), fireResistance.getAmplifier()));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    public void defendVillage(ICaptureAttributes totem) {
        this.goalSelector.removeGoal(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = false;
    }

    public void convertToMinion(@NotNull Player lord) {
        FactionPlayerHandler fph = FactionPlayerHandler.get(lord);
        if (fph.getMaxMinions() > 0) {
            MinionWorldData.getData(lord.level()).map(w -> w.getOrCreateController(fph)).ifPresent(controller -> {
                if (controller.hasFreeMinionSlot()) {
                    if (fph.getCurrentFaction() == this.getFaction()) {
                        boolean hasIncreasedStats = fph.getCurrentFactionPlayer().map(IFactionPlayer::getSkillHandler).map(skillHandler -> skillHandler.isSkillEnabled((ISkill)VampireSkills.MINION_STATS_INCREASE.get())).orElse(false);
                        VampireMinionEntity.VampireMinionData data = new VampireMinionEntity.VampireMinionData("Minion", this.getEntityTextureType(), false, hasIncreasedStats);
                        data.updateEntityCaps(this.serializeAttachments((HolderLookup.Provider)lord.registryAccess()));
                        int id = controller.createNewMinionSlot(data, (EntityType)ModEntities.VAMPIRE_MINION.get());
                        if (id < 0) {
                            LOGGER.error("Failed to get minion slot");
                            return;
                        }
                        VampireMinionEntity minion = (VampireMinionEntity)((EntityType)ModEntities.VAMPIRE_MINION.get()).create(this.level());
                        minion.claimMinionSlot(id, (PlayerMinionController)controller);
                        minion.copyPosition((Entity)this);
                        minion.markAsConverted();
                        controller.activateTask(0, (IMinionTask)MinionTasks.STAY.get());
                        UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                    } else {
                        LOGGER.warn("Wrong faction for minion");
                    }
                } else {
                    LOGGER.warn("No free slot");
                }
            });
        } else {
            LOGGER.error("Can't have minions");
        }
    }

    @Override
    public ActionHandlerEntity<?> getActionHandler() {
        return this.entityActionHandler;
    }

    @Nullable
    public IEntityLeader getAdvancedLeader() {
        return this.advancedLeader;
    }

    public void setAdvancedLeader(@Nullable IEntityLeader advancedLeader) {
        this.advancedLeader = advancedLeader;
    }

    @Override
    public boolean isFollowing() {
        return this.advancedLeader != null;
    }

    @Override
    public <T extends LivingEntity> T getLeader() {
        return (T)((LivingEntity)this.advancedLeader);
    }

    @Override
    public <T extends LivingEntity> void setLeader(T leader) {
        this.advancedLeader = (IEntityLeader)leader;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public void die(@NotNull DamageSource cause) {
        if (this.villageAttributes == null) {
            BadOmenEffect.handlePotentialBannerKill(cause.getEntity(), this);
        }
        super.die(cause);
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
         @NotNull BloodDrinkEvent.EntityDrinkBloodEvent event = VampirismEventFactory.fireVampireDrinkBlood(this, amt, saturationMod, useRemaining, drinkContext);
        this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, event.getAmount() * 20));
        boolean dedicated = ServerLifecycleHooks.getCurrentServer().isDedicatedServer();
        this.bloodtimer += event.getAmount() * 40 + this.getRandom().nextInt(1000) * (dedicated ? 2 : 1);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if ((reason == MobSpawnType.NATURAL || reason == MobSpawnType.STRUCTURE) && this.getRandom().nextInt(50) == 0) {
            this.setItemSlot(EquipmentSlot.HEAD, VampireVillage.createBanner((HolderLookup.Provider)worldIn.registryAccess()));
        }
        this.getEntityData().set(TYPE, (Object)this.getRandom().nextInt(126));
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Override
    public int getMaxEntityLevel() {
        return 2;
    }

    public int getAmbientSoundInterval() {
        return 2400;
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean isIgnoringSundamage() {
        float health = this.getHealth() / this.getMaxHealth();
        return super.isIgnoringSundamage() || this.angryTimer > 0 && health < 0.7f || health < 0.3f;
    }

    @Override
    public int getEntityTextureType() {
        int i = (Integer)this.getEntityData().get(TYPE);
        return Math.max(i, 0);
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.getEntityData().get(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.getEntityData().set(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1000000, 1, false, false));
            }
            if (level == 1) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float amount) {
        boolean flag = super.hurt(damageSource, amount);
        if (flag) {
            this.angryTimer += 120;
        }
        return flag;
    }

    public void remove(@NotNull Entity.RemovalReason p_146834_) {
        super.remove(p_146834_);
        if (this.advancedLeader != null) {
            this.advancedLeader.decreaseFollowerCount();
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.setCustomName(null);
        this.villageAttributes = null;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tagCompund) {
        super.readAdditionalSaveData(tagCompund);
        if (tagCompund.contains("level")) {
            this.setEntityLevel(tagCompund.getInt("level"));
        }
        if (tagCompund.contains("attack")) {
            this.attack = tagCompund.getBoolean("attack");
        }
        if (tagCompund.contains("type")) {
            int t = tagCompund.getInt("type");
            this.getEntityData().set(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.advancedLeader != null && !this.advancedLeader.getRepresentingEntity().isAlive()) {
            this.advancedLeader = null;
        }
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodtimer == 0;
    }

    @Override
    public int suggestEntityLevel(@NotNull de.teamlapen.vampirism.api.difficulty.Difficulty d) {
        return switch (this.random.nextInt(5)) {
            case 0 -> (int)((float)d.minPercLevel() / 100.0f * 2.0f);
            case 1 -> (int)((float)d.avgPercLevel() / 100.0f * 2.0f);
            case 2 -> (int)((float)d.maxPercLevel() / 100.0f * 2.0f);
            default -> this.random.nextInt(3);
        };
    }

    @Override
    protected float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        MobEffectInstance protection = this.getEffect((Holder)ModEffects.FIRE_PROTECTION);
        if (protection != null) {
            protectionMod = 1.0f / (2.0f + (float)protection.getAmplifier());
        }
        return (float)((double)(amount * protectionMod) * BalanceMobProps.mobProps.VAMPIRE_FIRE_VULNERABILITY) * ((float)this.getEntityLevel() * 0.5f + 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEVEL, (Object)-1);
        builder.define(TYPE, (Object)-1);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get();
    }

    protected int getBaseExperienceReward() {
        return 6 + this.getEntityLevel();
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.VAMPIRE_IMOB.get() : (EntityType)ModEntities.VAMPIRE.get();
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isAlive() && !player.isShiftKeyDown()) {
            FactionPlayerHandler handler;
            int vampireLevel;
            if (!this.level().isClientSide && (vampireLevel = (handler = FactionPlayerHandler.get(player)).getCurrentLevel(VReference.VAMPIRE_FACTION)) > 0) {
                if (handler.getMaxMinions() > 0) {
                    ItemStack heldItem = player.getItemInHand(hand);
                    boolean freeSlot = MinionWorldData.getData(player.level()).map(data -> data.getOrCreateController(handler)).map(c -> c.hasFreeMinionSlot()).orElse(false);
                    player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_vampire.minion.available"), true);
                    if (heldItem.getItem() == ModItems.VAMPIRE_MINION_BINDING.get()) {
                        if (!freeSlot) {
                            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_vampire.minion.no_free_slot"), true);
                        } else {
                            String key = switch (this.getRandom().nextInt(3)) {
                                case 0 -> "text.vampirism.basic_vampire.minion.start_serving1";
                                case 1 -> "text.vampirism.basic_vampire.minion.start_serving2";
                                default -> "text.vampirism.basic_vampire.minion.start_serving3";
                            };
                            player.displayClientMessage((Component)Component.translatable((String)key), false);
                            this.convertToMinion(player);
                            if (!player.getAbilities().instabuild) {
                                heldItem.shrink(1);
                            }
                        }
                    } else if (freeSlot) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.basic_vampire.minion.require_binding", (Object[])new Object[]{Component.translatable((String)((Item)ModItems.VAMPIRE_MINION_BINDING.get()).getDescriptionId())}), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BreakDoorGoal((Mob)this, difficulty -> difficulty == Difficulty.HARD));
        this.tasks_avoidHunter = new AvoidEntityGoal((PathfinderMob)this, PathfinderMob.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION));
        this.goalSelector.addGoal(2, this.tasks_avoidHunter);
        this.goalSelector.addGoal(2, new RestrictSunVampireGoal<BasicVampireEntity>(this));
        this.goalSelector.addGoal(3, new FleeSunVampireGoal<BasicVampireEntity>(this, 0.9, false));
        this.goalSelector.addGoal(4, (Goal)new AttackMeleeNoSunGoal(this, 1.0, false));
        this.goalSelector.addGoal(5, new BiteNearbyEntityVampireGoal<BasicVampireEntity>(this));
        this.goalSelector.addGoal(6, (Goal)new FollowAdvancedVampireGoal(this, 1.0));
        this.goalSelector.addGoal(7, new MoveToBiteableVampireGoal<BasicVampireEntity>(this, 0.75));
        this.goalSelector.addGoal(8, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.6, true, 600, () -> false));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, new AttackVillageGoal<BasicVampireEntity>(this));
        this.targetSelector.addGoal(4, new DefendVillageGoal<BasicVampireEntity>(this));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey<Structure>)StructureTags.VILLAGE)));
        this.targetSelector.addGoal(8, new DefendLeaderGoal<BasicVampireEntity>(this));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        AttributeInstance attributeInstance = this.getAttribute(Attributes.MAX_HEALTH);
        double d = BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION;
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.setBaseValue(d + 3.0 * (double)l);
        AttributeInstance attributeInstance2 = this.getAttribute(Attributes.ATTACK_DAMAGE);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance2.setBaseValue(3.0 + 1.0 * (double)l);
    }

    public static class IMob
    extends BasicVampireEntity
    implements Enemy {
        public IMob(EntityType<? extends BasicVampireEntity> type, Level world) {
            super(type, world);
        }
    }
}

