/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.unlock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.core.ModTasks;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class LvlUnlocker
implements TaskUnlocker {
    public static final MapCodec<LvlUnlocker> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("reqLevel").forGetter(i -> i.reqLevel), (App)Codec.INT.optionalFieldOf("maxLevel", (Object)-1).forGetter(i -> i.maxLevel)).apply((Applicative)inst, LvlUnlocker::new));
    private final int reqLevel;
    private final int maxLevel;

    public LvlUnlocker(int reqLevel) {
        this(reqLevel, -1);
    }

    public LvlUnlocker(int reqLevel, int maxLevel) {
        this.reqLevel = reqLevel;
        this.maxLevel = maxLevel;
    }

    @Override
    @NotNull
    public Component getDescription() {
        MutableComponent t = Component.translatable((String)"text.vampirism.level_min", (Object[])new Object[]{this.reqLevel});
        if (this.maxLevel > 0) {
            t.append(" ").append((Component)Component.translatable((String)"text.vampirism.level_max", (Object[])new Object[]{this.maxLevel}));
        }
        return t;
    }

    @Override
    public boolean isUnlocked(@NotNull IFactionPlayer<?> playerEntity) {
        return playerEntity.getLevel() >= this.reqLevel && (this.maxLevel <= 0 || playerEntity.getLevel() <= this.maxLevel);
    }

    @Override
    public MapCodec<? extends TaskUnlocker> codec() {
        return (MapCodec)ModTasks.LEVEL_UNLOCKER.get();
    }
}

