/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.req;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record ItemRequirement(@NotNull ResourceLocation id, @NotNull ItemStack stack, @NotNull Component description) implements TaskRequirement.Requirement<Item>
{
    public static final MapCodec<ItemRequirement> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceLocation.CODEC.optionalFieldOf("id").forGetter(i -> Optional.of(i.id)), (App)ItemStack.CODEC.fieldOf("item").forGetter(i -> i.stack), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(i -> i.description)).apply((Applicative)inst, (id, item, desc) -> new ItemRequirement(id.orElseGet(() -> RegUtil.id(item.getItem())), (ItemStack)item, (Component)desc)));

    public ItemRequirement(ItemStack itemRequirement, Component description) {
        this(RegUtil.id(itemRequirement.getItem()), itemRequirement, description);
    }

    @Override
    public int getAmount(IFactionPlayer<?> player) {
        return this.stack.getCount();
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    @NotNull
    public Item getStat(IFactionPlayer<?> player) {
        return this.stack.getItem();
    }

    @Override
    @NotNull
    public TaskRequirement.Type getType() {
        return TaskRequirement.Type.ITEMS;
    }

    @Override
    public void removeRequirement(@NotNull IFactionPlayer<?> player) {
        player.asEntity().getInventory().clearOrCountMatchingItems(itemStack -> ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)this.stack), this.getAmount(player), (Container)player.asEntity().inventoryMenu.getCraftSlots());
    }

    @Override
    public MapCodec<? extends TaskRequirement.Requirement<?>> codec() {
        return (MapCodec)ModTasks.ITEM_REQUIREMENT.get();
    }
}

