/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;

public record SkillNode(@NotNull List<Holder<ISkill<?>>> skills, @NotNull List<ResourceKey<ISkillNode>> lockingNodes) implements ISkillNode
{
    public static final Codec<ISkillNode> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.nonEmptyList((Codec)ModRegistries.SKILLS.holderByNameCodec().listOf()).fieldOf("skills").forGetter(ISkillNode::skills), (App)Codec.lazyInitialized(() -> ResourceKey.codec(VampirismRegistries.Keys.SKILL_NODE)).listOf().optionalFieldOf("locking_nodes", List.of()).forGetter(ISkillNode::lockingNodes)).apply((Applicative)inst, SkillNode::new)));

    public SkillNode(@NotNull List<Holder<ISkill<?>>> elements) {
        this(elements, new ArrayList<ResourceKey<ISkillNode>>());
    }

    public SkillNode(@NotNull List<Holder<ISkill<?>>> elements, @NotNull Optional<List<ResourceKey<ISkillNode>>> lockingNodes) {
        this(elements, lockingNodes.orElse(List.of()));
    }

    @SafeVarargs
    public SkillNode(Holder<ISkill<?>> ... skill) {
        this(Arrays.asList(skill), new ArrayList<ResourceKey<ISkillNode>>());
    }

    @Override
    public boolean containsSkill(ISkill<?> skill) {
        return this.skills.stream().map(Holder::value).anyMatch(s -> s == skill);
    }
}

