/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.lord.actions;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.DefaultAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.IVampirismPlayer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class LordRangeEffectAction<T extends IFactionPlayer<T>>
extends DefaultAction<T> {
    private final Holder<MobEffect> effect;

    public LordRangeEffectAction(Holder<MobEffect> effect) {
        this.effect = effect;
    }

    @Override
    protected boolean activate(@NotNull T player, IAction.ActivationContext context) {
        int lordLevel = FactionPlayerHandler.get(player.asEntity()).getLordLevel();
        List entitiesOfClass = player.asEntity().level().getEntitiesOfClass(LivingEntity.class, new AABB(player.asEntity().blockPosition()).inflate(10.0, 10.0, 10.0), e -> player.getFaction() == VampirismAPI.factionRegistry().getFaction((Entity)e));
        for (LivingEntity entity : entitiesOfClass) {
            if (entity instanceof Player && FactionPlayerHandler.get((Player)entity).getLordLevel() >= lordLevel) continue;
            entity.addEffect(new MobEffectInstance(this.effect, this.getEffectDuration(player), this.getEffectAmplifier(player)));
        }
        return !entitiesOfClass.isEmpty();
    }

    protected abstract int getEffectDuration(T var1);

    @Override
    public int getCooldown(T player) {
        return this.getEffectDuration(player);
    }

    protected int getEffectAmplifier(@NotNull T player) {
        return ((IVampirismPlayer)player.asEntity()).getVampAtts().lordLevel - 1;
    }

    @Override
    @NotNull
    public Optional<IPlayableFaction<?>> getFaction() {
        return Optional.empty();
    }
}

