/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import com.google.common.collect.Streams;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IFactionSlayerItem;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.blocks.AltarInspirationBlock;
import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.mother.MotherBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.effects.VampirismPotion;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.BatVampireAction;
import de.teamlapen.vampirism.items.GarlicBreadItem;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.TotemHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ModPlayerEventHandler {
    @SubscribeEvent
    public void blockDestroyed(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (event.getPlayer().isCreative()) {
            return;
        }
        if (((Boolean)VampirismConfig.SERVER.allowVillageDestroyBlocks.get()).booleanValue()) {
            return;
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        List<PoiRecord> inSquare = TotemHelper.findRecords(level, event.getPos()).toList();
        if (!inSquare.isEmpty()) {
            Block block = event.getState().getBlock();
            Optional<PoiRecord> self = inSquare.stream().filter(x -> x.getPos() == event.getPos()).findAny();
            if (self.isPresent()) {
                positions.add(self.get().getPos());
            } else {
                positions.addAll(inSquare.stream().map(PoiRecord::getPos).filter(pos -> level.getBlockState(pos).getBlock() == block).toList());
            }
        }
        for (BlockPos position : positions) {
            Player player;
            TotemBlockEntity blockEntity;
            BlockEntity totem;
            BlockPos totemPosition = TotemHelper.getTotemPosition((ResourceKey<Level>)level.dimension(), position);
            if (totemPosition == null || !level.isLoaded(totemPosition) || !((totem = event.getLevel().getBlockEntity(totemPosition)) instanceof TotemBlockEntity) || (blockEntity = (TotemBlockEntity)totem).getControllingFaction() == null || VampirismPlayerAttributes.get((Player)event.getPlayer()).faction == blockEntity.getControllingFaction()) continue;
            event.setCanceled(true);
            event.getPlayer().displayClientMessage((Component)Component.translatable((String)"text.vampirism.village.totem_destroy.fail_totem_faction"), true);
            if (positions.isEmpty() || !((player = event.getPlayer()) instanceof ServerPlayer)) continue;
            ServerPlayer player2 = (ServerPlayer)player;
            positions.forEach(pos -> {
                Packet pkt;
                player.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)event.getLevel(), pos));
                BlockEntity tileentity = event.getLevel().getBlockEntity(pos);
                if (tileentity != null && (pkt = tileentity.getUpdatePacket()) != null) {
                    player.connection.send(pkt);
                }
            });
        }
    }

    @SubscribeEvent
    public void eyeHeight(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityEvent.Size event) {
        if (event.getEntity() instanceof Player && ((Player)event.getEntity()).getInventory() != null && event.getEntity().isAlive() && event.getEntity().position().lengthSqr() != 0.0 && event.getEntity().getVehicle() == null) {
            if (VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getVampSpecial().bat) {
                event.setNewSize(BatVampireAction.BAT_SIZE);
            } else if (VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getVampSpecial().isDBNO) {
                event.setNewSize(EntityDimensions.fixed((float)0.6f, (float)0.95f).withEyeHeight(0.725f));
            }
        }
    }

    @SubscribeEvent
    public void onTryMount(@NotNull EntityMountEvent event) {
        if (event.getEntity() instanceof Player && VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(@NotNull AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.isAlive()) {
            if (VampirismPlayerAttributes.get((Player)player).getVampSpecial().bat) {
                event.setCanceled(true);
            }
            HunterPlayer.get(player).breakDisguise();
            if (!this.checkItemUsePerm(player.getMainHandItem(), player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.BreakEvent event) {
        HunterPlayer.get(event.getPlayer()).breakDisguise();
    }

    @SubscribeEvent
    public void onBlockPlaced(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof Player) || !event.getEntity().isAlive()) {
            return;
        }
        if (event.getPlacedBlock().isAir()) {
            return;
        }
        try {
            if (VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().isCannotInteract()) {
                MinecraftServer server;
                BlockEntity t;
                event.setCanceled(true);
                if (event.getPlacedBlock().hasBlockEntity() && (t = event.getLevel().getBlockEntity(event.getPos())) instanceof Container) {
                    ((Container)t).clearContent();
                }
                if (event.getEntity() instanceof ServerPlayer && (server = event.getEntity().level().getServer()) != null) {
                    server.getPlayerList().sendAllPlayerInfo((ServerPlayer)event.getEntity());
                }
            }
            HunterPlayer.get((Player)event.getEntity()).breakDisguise();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.BreakSpeed event) {
        if (VampirismPlayerAttributes.get(event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCanceled(true);
        } else if ((ModBlocks.GARLIC_DIFFUSER_NORMAL.get() == event.getState().getBlock() || ModBlocks.GARLIC_DIFFUSER_WEAK.get() == event.getState().getBlock() || ModBlocks.GARLIC_DIFFUSER_IMPROVED.get() == event.getState().getBlock()) && VampirismPlayerAttributes.get((Player)event.getEntity()).vampireLevel > 0) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.1f);
        }
    }

    @SubscribeEvent
    public void onItemPickupPre(@NotNull ItemEntityPickupEvent.Pre event) {
        if (VampirismPlayerAttributes.get((Player)event.getPlayer()).getVampSpecial().isDBNO) {
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public void onItemRightClick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.RightClickItem event) {
        if (!this.checkItemUsePerm(event.getItemStack(), event.getEntity())) {
            event.setCanceled(true);
        }
        if ((event.getItemStack().getItem() instanceof ThrowablePotionItem || event.getItemStack().getItem() instanceof CrossbowItem) && VampirismPlayerAttributes.get(event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (VampirismPlayerAttributes.get(player).getVampSpecial().isCannotInteract()) {
                event.setCanceled(true);
            }
            if (!this.checkItemUsePerm(event.getItem(), player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        if (Helper.isVampire(event.getEntity()) && VampirismPlayerAttributes.get(event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Finish event) {
        PotionContents contents;
        ItemStack stack;
        if (Helper.isVampire((Entity)event.getEntity()) && event.getItem().getItem() instanceof GarlicBreadItem && !event.getEntity().getCommandSenderWorld().isClientSide) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof IVampire) {
                IVampire vampire = (IVampire)livingEntity;
                DamageHandler.affectVampireGarlicDirect(vampire, EnumStrength.MEDIUM);
            } else {
                livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    DamageHandler.affectVampireGarlicDirect(VampirePlayer.get(player), EnumStrength.MEDIUM);
                }
            }
        }
        if (!Helper.isHunter((Entity)event.getEntity()) && (stack = event.getItem()).getItem() == Items.POTION && (contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().map(s -> s.value() instanceof VampirismPotion.HunterPotion).orElse(false).booleanValue() && StreamSupport.stream(contents.getAllEffects().spliterator(), false).map(MobEffectInstance::getEffect).map(Holder::value).anyMatch(MobEffect::isBeneficial)) {
            event.getEntity().addEffect(new MobEffectInstance(ModEffects.POISON, Integer.MAX_VALUE, 4));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingAttack(@NotNull LivingIncomingDamageEvent event) {
        if (event.getEntity() instanceof Player && event.getEntity().isAlive() && !FactionPlayerHandler.get((Player)event.getEntity()).onEntityAttacked(event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
        if (event.getSource().getEntity() instanceof Player) {
            HunterPlayer.get((Player)event.getSource().getEntity()).breakDisguise();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeathFirst(@NotNull LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && VampirePlayer.get(player = (Player)livingEntity).onDeadlyHit(event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFall(@NotNull LivingFallEvent event) {
        if (event.getEntity() instanceof Player) {
            event.setDistance(event.getDistance() - (float)VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().getJumpBoost());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurt(@NotNull LivingDamageEvent.Pre event) {
        LivingEntity mod2;
        Player player;
        LivingEntity livingEntity;
        DamageContainer d = event.getContainer();
        if (!d.getSource().is(DamageTypeTags.WITCH_RESISTANT_TO) && !d.getSource().is(DamageTypeTags.BYPASSES_ARMOR) && event.getEntity() instanceof Player && VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getVampSpecial().bat) {
            d.setNewDamage(event.getContainer().getNewDamage() * 2.0f);
        }
        if ((livingEntity = event.getEntity()) instanceof Player && Helper.isVampire(player = (Player)livingEntity)) {
            float mod2 = (float)(0.2 * (double)VampirePlayer.getOpt(player).map(s -> Float.valueOf((float)s.getLevel() / (float)s.getMaxLevel())).orElse(Float.valueOf(0.0f)).floatValue());
            d.setNewDamage(d.getNewDamage() * (1.0f - mod2));
        }
        if ((mod2 = event.getEntity()) instanceof Player && Helper.isHunter(player = (Player)mod2)) {
            float swiftnessDodgeChance = (float)Streams.stream((Iterable)player.getArmorSlots()).filter(s -> s.is(ModTags.Items.ARMOR_OF_SWIFTNESS)).mapToDouble(x -> 0.025).sum();
            if (swiftnessDodgeChance == 0.1f) {
                swiftnessDodgeChance = 0.2f;
            }
            if (player.getRandom().nextFloat() < swiftnessDodgeChance) {
                event.setNewDamage(0.0f);
                return;
            }
            if (event.getSource().getEntity() != null && !Helper.isHunter(event.getSource().getEntity())) {
                float coatReduction = (float)Streams.stream((Iterable)player.getArmorSlots()).filter(s -> s.is(ModTags.Items.HUNTER_COAT)).mapToDouble(x -> 0.025).sum();
                if (coatReduction == 0.1f) {
                    coatReduction = 0.2f;
                }
                event.setNewDamage(event.getNewDamage() * (1.0f - coatReduction));
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof Player) {
            event.getEntity().setDeltaMovement(event.getEntity().getDeltaMovement().add(0.0, (double)((float)VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().getJumpBoost() * 0.1f), 0.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldStack;
        if (event.getLevel().getWorldBorder().isWithinBounds(event.getPos()) && !(heldStack = event.getItemStack()).isEmpty() && heldStack.getCount() == 1) {
            boolean bloodBottle;
            boolean glassBottle = Items.GLASS_BOTTLE.equals(heldStack.getItem());
            boolean bl = bloodBottle = ModItems.BLOOD_BOTTLE.get() == heldStack.getItem();
            if (bloodBottle || glassBottle && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
                BlockEntity entity;
                Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
                BlockState state = event.getLevel().getBlockState(event.getPos());
                boolean convert = false;
                if (glassBottle && state.hasBlockEntity() && (entity = event.getLevel().getBlockEntity(event.getPos())) != null) {
                    convert = Optional.ofNullable((IFluidHandler)event.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, event.getPos(), state, entity, (Object)event.getFace())).map(fluidHandler -> {
                        boolean flag = false;
                        FluidStack drain = fluidHandler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), 1000), IFluidHandler.FluidAction.SIMULATE);
                        if (drain.getAmount() >= 100) {
                            flag = true;
                        }
                        if (flag && block instanceof AltarInspirationBlock) {
                            flag = false;
                        }
                        if (flag && block instanceof BloodContainerBlock) {
                            flag = false;
                        }
                        return flag;
                    }).orElse(false);
                }
                if ((bloodBottle || convert) && block instanceof BloodContainerBlock) {
                    event.setUseBlock(TriState.TRUE);
                }
                if (convert) {
                    InteractionHand hand = heldStack.equals(event.getEntity().getMainHandItem()) ? InteractionHand.MAIN_HAND : (heldStack.equals(event.getEntity().getOffhandItem()) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                    heldStack = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get());
                    event.getEntity().setItemInHand(hand, heldStack);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickedBlock(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        if (event.getFace() == null) {
            return;
        }
        Level world = event.getLevel();
        BlockState state = world.getBlockState(pos = event.getPos());
        if (state.getBlock() == ModBlocks.ALCHEMICAL_FIRE.get()) {
            BlockPos pos1 = event.getPos().relative(event.getFace());
            BlockState state1 = world.getBlockState(pos);
            world.levelEvent(null, 1009, pos, 0);
            world.removeBlock(pos, false);
            event.setCanceled(true);
        } else if ((ModBlocks.GARLIC_DIFFUSER_NORMAL.get() == state.getBlock() || ModBlocks.GARLIC_DIFFUSER_WEAK.get() == state.getBlock() || ModBlocks.GARLIC_DIFFUSER_IMPROVED.get() == state.getBlock()) && Helper.isVampire(event.getEntity())) {
            event.getEntity().addEffect(new MobEffectInstance(ModEffects.GARLIC));
        } else if (state.getBlock() instanceof MotherBlock) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerName(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.NameFormat event) {
        if (event.getEntity() != null && ((Boolean)VampirismConfig.SERVER.factionColorInChat.get()).booleanValue()) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(event.getEntity());
            handler.getCurrentFactionPlayer().ifPresent(fp -> {
                IFaction<?> f = fp.getDisguisedAs();
                if (f != null) {
                    MutableComponent displayName = handler.getLordLevel() > 0 && (Boolean)VampirismConfig.SERVER.lordPrefixInChat.get() != false ? Component.literal((String)"[").append(handler.getLordTitle()).append("] ").append(event.getDisplayname()) : event.getDisplayname().copy();
                    event.setDisplayname((Component)displayName.withStyle(style -> style.withColor(f.getChatColor())));
                }
            });
        }
    }

    @SubscribeEvent
    public void canContinueToSleep(CanContinueSleepingEvent event) {
        if (Helper.isVampire((Entity)event.getEntity()) && event.getEntity().getSleepingPos().map(s -> event.getEntity().level().getBlockState(s)).map(s -> s.getBlock() instanceof CoffinBlock).orElse(false).booleanValue()) {
            boolean day = Helper.isDay((LevelAccessor)event.getEntity().level());
            if (day && event.getProblem() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW) {
                event.setContinueSleeping(true);
            } else if (!day) {
                event.setContinueSleeping(false);
            }
        }
    }

    @SubscribeEvent
    public void sleepTimeFinish(@NotNull SleepFinishedTimeEvent event) {
        boolean sleepingInCoffin;
        if (event.getLevel() instanceof ServerLevel && Helper.isDay(event.getLevel()) && (sleepingInCoffin = event.getLevel().players().stream().anyMatch(player -> {
            Optional pos = player.getSleepingPos();
            return pos.isPresent() && event.getLevel().getBlockState((BlockPos)pos.get()).getBlock() instanceof CoffinBlock;
        }))) {
            long dist = ((ServerLevel)event.getLevel()).getDayTime() % 24000L > 12000L ? 13000L : -11000L;
            event.setTimeAddition(event.getNewTime() + dist);
        }
    }

    private boolean checkItemUsePerm(@NotNull ItemStack stack, @NotNull Player player) {
        Item item;
        boolean message;
        boolean bl = message = !player.getCommandSenderWorld().isClientSide;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof IFactionExclusiveItem) {
            IFactionExclusiveItem factionItem = (IFactionExclusiveItem)item;
            if (!player.isAlive()) {
                return false;
            }
            FactionPlayerHandler handler = FactionPlayerHandler.get(player);
            IFaction<?> usingFaction = factionItem.getExclusiveFaction(stack);
            if (usingFaction != null && !handler.isInFaction(usingFaction)) {
                if (message) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.can_not_be_used_faction"), true);
                }
                return false;
            }
            Item item2 = stack.getItem();
            if (item2 instanceof IFactionLevelItem) {
                IFactionPlayer factionPlayer;
                IFactionLevelItem levelItem = (IFactionLevelItem)item2;
                ISkill requiredSkill = levelItem.getRequiredSkill(stack);
                if (handler.getCurrentLevel() < levelItem.getMinLevel(stack)) {
                    if (message) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.can_not_be_used_level"), true);
                    }
                    return false;
                }
                if (!(requiredSkill == null || (factionPlayer = (IFactionPlayer)handler.getCurrentFactionPlayer().orElse(null)) != null && factionPlayer.getSkillHandler().isSkillEnabled(requiredSkill))) {
                    if (message) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.can_not_be_used_skill"), true);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onPlayerAttackCritical(@NotNull CriticalHitEvent event) {
        Item item;
        ItemStack stack = event.getEntity().getMainHandItem();
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof IFactionSlayerItem) {
            IFactionSlayerItem item2 = (IFactionSlayerItem)item;
            IFaction<?> faction = VampirismAPI.factionRegistry().getFaction(event.getTarget());
            if (faction != null && faction.equals(item2.getSlayedFaction())) {
                event.setDamageMultiplier(event.getDamageMultiplier() + event.getVanillaMultiplier() * (item2.getDamageMultiplierForFaction(stack) - 1.0f));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerGameMode(PlayerEvent.PlayerChangeGameModeEvent event) {
        if (event.getNewGameMode() == GameType.SPECTATOR) {
            FactionPlayerHandler.getCurrentFactionPlayer(event.getEntity()).ifPresent(factionPlayer -> factionPlayer.getActionHandler().deactivateAllActions());
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        FactionPlayerHandler.get(event.getEntity()).checkSkillTreeLocks();
    }

    @SubscribeEvent
    public void canStartSleeping(CanPlayerSleepEvent event) {
        if (Helper.isVampire((Player)event.getEntity()) && event.getState().is(ModTags.Blocks.COFFIN)) {
            Player.BedSleepingProblem bedSleepingProblem = event.getProblem();
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"OTHER_PROBLEM", "NOT_POSSIBLE_HERE", "TOO_FAR_AWAY"}, (Player.BedSleepingProblem)bedSleepingProblem, n)) {
                case 0: 
                case 1: 
                case 2: {
                    return;
                }
            }
            if (((Boolean)event.getState().getValue((Property)CoffinBlock.VERTICAL)).booleanValue()) {
                BlockPos relative = event.getPos().relative(((Direction)event.getState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite());
                if (ModPlayerEventHandler.obstructedAt(event.getLevel(), relative) || ModPlayerEventHandler.obstructedAt(event.getLevel(), relative.above())) {
                    event.setProblem(Player.BedSleepingProblem.OBSTRUCTED);
                    return;
                }
            } else {
                BlockPos above = event.getPos().above();
                if (ModPlayerEventHandler.obstructedAt(event.getLevel(), above) || ModPlayerEventHandler.obstructedAt(event.getLevel(), above.relative(((Direction)event.getState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()))) {
                    event.setProblem(Player.BedSleepingProblem.OBSTRUCTED);
                    return;
                }
            }
            event.getEntity().setRespawnPosition(event.getLevel().dimension(), event.getPos(), event.getEntity().getYRot(), false, true);
            if (!Helper.isDay((LevelAccessor)event.getLevel())) {
                event.setProblem(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            } else {
                event.setProblem(null);
            }
        }
    }

    private static boolean obstructedAt(Level level, BlockPos pos) {
        return level.getBlockState(pos).isSuffocating((BlockGetter)level, pos);
    }
}

