/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import com.google.common.collect.ImmutableList;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MinionInventory
implements IMinionInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)25, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> inventoryHands = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> inventoryArmor = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> allInventories = ImmutableList.of(this.inventoryHands, this.inventoryArmor, this.inventory);
    private int availableSize;

    public MinionInventory(int availableSize) {
        assert (availableSize == 9 || availableSize == 12 || availableSize == 15);
        this.availableSize = availableSize;
    }

    public MinionInventory() {
        this(9);
    }

    @Override
    public void addItemStack(@NotNull ItemStack stack) {
        int slot;
        while (!stack.isEmpty() && (slot = InventoryHelper.getFirstSuitableSlotToAdd(this.inventory, this.getContainerSize() - 6, stack, this.getMaxStackSize())) != -1) {
            int oldSize = stack.getCount();
            InventoryHelper.addStackToSlotWithoutCheck(this, slot + 6, stack);
            if (stack.getCount() < oldSize) continue;
            break;
        }
    }

    public void clearContent() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }

    public int getContainerSize() {
        return 6 + this.availableSize;
    }

    @Override
    public int getAvailableSize() {
        return this.availableSize;
    }

    @NotNull
    public MinionInventory setAvailableSize(int newSize) {
        assert (newSize == 9 || newSize == 12 || newSize == 15);
        this.availableSize = newSize;
        return this;
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getInventoryArmor() {
        return this.inventoryArmor;
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getInventoryHands() {
        return this.inventoryHands;
    }

    @Override
    public List<NonNullList<ItemStack>> getAllInventorys() {
        return this.allInventories;
    }

    @NotNull
    public ItemStack getItem(int index) {
        assert (index >= 0);
        if (index < 2) {
            return (ItemStack)this.inventoryHands.get(index);
        }
        if (index < 6) {
            return (ItemStack)this.inventoryArmor.get(index - 2);
        }
        if (index < 6 + this.availableSize) {
            return (ItemStack)this.inventory.get(index - 6);
        }
        return ItemStack.EMPTY;
    }

    public void read(HolderLookup.Provider provider, @NotNull ListTag nbtTagListIn) {
        this.inventory.clear();
        this.inventoryArmor.clear();
        this.inventoryHands.clear();
        for (int i = 0; i < nbtTagListIn.size(); ++i) {
            CompoundTag compoundTag = nbtTagListIn.getCompound(i);
            int j = compoundTag.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag).orElse(ItemStack.EMPTY);
            if (itemstack.isEmpty()) continue;
            if (j < this.inventoryHands.size()) {
                this.inventoryHands.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 10 && j < this.inventoryArmor.size() + 10) {
                this.inventoryArmor.set(j - 10, (Object)itemstack);
                continue;
            }
            if (j < 20 || j >= this.inventory.size() + 20) continue;
            this.inventory.set(j - 20, (Object)itemstack);
        }
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.inventoryHands) {
            if (itemstack1.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.inventoryArmor) {
            if (itemstack2.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        ItemStack s = this.getItem(index);
        return !s.isEmpty() && count > 0 ? s.split(count) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack s = this.getItem(index);
        if (!s.isEmpty()) {
            this.setItem(index, ItemStack.EMPTY);
        }
        return s;
    }

    public void setChanged() {
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        assert (index >= 0);
        if (index < 2) {
            this.inventoryHands.set(index, (Object)stack);
        } else if (index < 6) {
            this.inventoryArmor.set(index - 2, (Object)stack);
        } else if (index < 6 + this.availableSize) {
            this.inventory.set(index - 6, (Object)stack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public ListTag write(HolderLookup.Provider provider, @NotNull ListTag nbt) {
        CompoundTag compoundTag;
        int i;
        for (i = 0; i < this.inventoryHands.size(); ++i) {
            if (((ItemStack)this.inventoryHands.get(i)).isEmpty()) continue;
            compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)i);
            nbt.add((Object)((ItemStack)this.inventoryHands.get(i)).save(provider, (Tag)compoundTag));
        }
        for (i = 0; i < this.inventoryArmor.size(); ++i) {
            if (((ItemStack)this.inventoryArmor.get(i)).isEmpty()) continue;
            compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)(i + 10));
            nbt.add((Object)((ItemStack)this.inventoryArmor.get(i)).save(provider, (Tag)compoundTag));
        }
        for (i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).isEmpty()) continue;
            compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)(i + 20));
            nbt.add((Object)((ItemStack)this.inventory.get(i)).save(provider, (Tag)compoundTag));
        }
        return nbt;
    }
}

