/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinionDamageSource
extends DamageSource {
    @NotNull
    protected final MinionEntity<?> minionEntity;
    @Nullable
    protected final Player playerEntity;

    public MinionDamageSource(Holder<DamageType> damageType, @NotNull MinionEntity<?> minion) {
        super(damageType, minion, (Entity)minion.getLordOpt().map(ILordPlayer::getPlayer).orElse(null));
        this.minionEntity = minion;
        this.playerEntity = (Player)this.getEntity();
    }

    @NotNull
    public Component getLocalizedDeathMessage(@NotNull LivingEntity entityLivingBaseIn) {
        MutableComponent msg;
        Component minionName = this.minionEntity.getDisplayName();
        ItemStack itemstack = this.minionEntity.getMainHandItem();
        String s = "death.attack." + this.type().msgId();
        String s1 = s + ".item";
        MutableComponent mutableComponent = msg = !itemstack.isEmpty() && itemstack.get(DataComponents.CUSTOM_NAME) != null ? Component.translatable((String)s1, (Object[])new Object[]{entityLivingBaseIn.getDisplayName(), minionName, itemstack.getDisplayName()}) : Component.translatable((String)s, (Object[])new Object[]{entityLivingBaseIn.getDisplayName(), minionName});
        if (this.playerEntity != null) {
            msg.append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"death.minion.on_behalf", (Object[])new Object[]{this.playerEntity.getDisplayName()}));
        }
        return msg;
    }
}

