/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;

public class PlayableFaction<T extends IFactionPlayer<T>>
extends Faction<T>
implements IPlayableFaction<T> {
    private final int highestLevel;
    private final int highestLordLevel;
    private final Supplier<AttachmentType<T>> playerCapabilitySupplier;
    private final BiFunction<Integer, IPlayableFaction.TitleGender, Component> lordTitleFunction;
    private final Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot;
    private final boolean hasLordSkills;

    PlayableFaction(@NotNull FactionRegistry.PlayableFactionBuilder<T> builder) {
        super(builder);
        this.highestLevel = builder.highestLevel;
        this.highestLordLevel = builder.lord.maxLevel;
        this.playerCapabilitySupplier = builder.playerCapabilitySupplier;
        this.lordTitleFunction = builder.lord.lordTitleFunction;
        this.refinementItemBySlot = builder.refinementItemBySlot;
        this.hasLordSkills = builder.lord.lordSkillsEnabled;
    }

    @Override
    public Class<T> getFactionPlayerInterface() {
        return super.getFactionEntityInterface();
    }

    @Override
    public int getHighestLordLevel() {
        return this.highestLordLevel;
    }

    @Override
    public int getHighestReachableLevel() {
        return this.highestLevel;
    }

    @Override
    public boolean hasLordSkills() {
        return this.hasLordSkills;
    }

    @Override
    @NotNull
    public Component getLordTitle(int level, IPlayableFaction.TitleGender female) {
        assert (level <= this.highestLordLevel);
        return this.lordTitleFunction.apply(level, female);
    }

    @Override
    @NotNull
    public Optional<T> getPlayerCapability(@NotNull Player player) {
        return Optional.ofNullable((IFactionPlayer)player.getData(this.playerCapabilitySupplier.get()));
    }

    @Override
    public boolean hasRefinements() {
        return this.refinementItemBySlot != null;
    }

    @Override
    public <Z extends Item> Z getRefinementItem(IRefinementItem.AccessorySlotType type) {
        assert (this.refinementItemBySlot != null);
        return (Z)((Item)this.refinementItemBySlot.apply(type));
    }

    @Override
    @NotNull
    public String toString() {
        return "PlayableFaction{id='" + String.valueOf(this.id) + "'}";
    }
}

