/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillage;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillageBuilder;
import de.teamlapen.vampirism.entity.factions.FactionVillage;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class FactionVillageBuilder
implements IFactionVillageBuilder {
    Holder<MobEffect> badOmenEffect = null;
    Function<HolderLookup.Provider, ItemStack> bannerStack = provider -> new ItemStack((ItemLike)Items.WHITE_BANNER);
    List<CaptureEntityEntry<?>> captureEntities = Collections.emptyList();
    Supplier<VillagerProfession> factionVillageProfession = () -> VillagerProfession.NONE;
    Class<? extends Mob> guardSuperClass = Mob.class;
    Supplier<EntityType<? extends ITaskMasterEntity>> taskMasterEntity = () -> null;
    Supplier<? extends Block> fragileTotem = () -> Blocks.AIR;
    Supplier<? extends Block> craftedTotem = () -> Blocks.AIR;

    @Override
    @NotNull
    public IFactionVillageBuilder badOmenEffect(Holder<MobEffect> badOmenEffect) {
        this.badOmenEffect = badOmenEffect;
        return this;
    }

    @Override
    @NotNull
    public IFactionVillageBuilder banner(Function<HolderLookup.Provider, ItemStack> bannerItem) {
        this.bannerStack = bannerItem;
        return this;
    }

    @Override
    @NotNull
    public IFactionVillageBuilder captureEntities(List<CaptureEntityEntry<?>> captureEntities) {
        this.captureEntities = captureEntities;
        return this;
    }

    @Override
    @NotNull
    public IFactionVillageBuilder factionVillagerProfession(Supplier<VillagerProfession> profession) {
        this.factionVillageProfession = profession;
        return this;
    }

    @Override
    @NotNull
    public IFactionVillageBuilder guardSuperClass(Class<? extends Mob> clazz) {
        this.guardSuperClass = clazz;
        return this;
    }

    @Override
    @NotNull
    public <Z extends Entity> IFactionVillageBuilder taskMaster(Supplier<EntityType<Z>> taskmaster) {
        this.taskMasterEntity = taskmaster;
        return this;
    }

    @Override
    @NotNull
    public IFactionVillageBuilder totem(Supplier<? extends Block> fragile, Supplier<? extends Block> crafted) {
        this.fragileTotem = fragile;
        this.craftedTotem = crafted;
        return this;
    }

    @Override
    @NotNull
    public IFactionVillage build() {
        return new FactionVillage(this);
    }
}

