/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.advancements.critereon.CuredVampireVillagerCriterionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAi;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.converted.CurableConvertedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.mixin.accessor.VillagerAccessor;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.TotemHelper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class ConvertedVillagerEntity
extends VampirismVillagerEntity
implements CurableConvertedCreature<Villager, ConvertedVillagerEntity> {
    @NotNull
    public static final List<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES;
    private static final EntityDataAccessor<Boolean> CONVERTING;
    private static final EntityDataAccessor<String> OVERLAY_TEXTURE;
    @NotNull
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;
    private final CurableConvertedCreature.Data<Villager> convertedData = new CurableConvertedCreature.Data();

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return VampirismVillagerEntity.createAttributes().add(ModAttributes.SUNDAMAGE);
    }

    public ConvertedVillagerEntity(EntityType<? extends ConvertedVillagerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addAdditionalSaveDataC(compound);
    }

    @Override
    public void aiStep() {
        this.aiStepC(EntityType.VILLAGER);
        ++this.bloodTimer;
        super.aiStep();
    }

    public Optional<BlockPos> getClosestVampireForest(Level level, BlockPos blockPos) {
        Optional<Object> optional;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            optional = TotemHelper.getTotemNearPos(serverLevel, blockPos, true).flatMap(TotemBlockEntity::getVampireForestLocation);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    @NotNull
    public Villager cureEntity(@NotNull ServerLevel world, @NotNull PathfinderMob entity, @NotNull EntityType<Villager> newType) {
        Player playerentity;
        Villager villager = CurableConvertedCreature.super.cureEntity(world, entity, newType);
        if (((CurableConvertedCreature.Data)this.data()).conversationStarter != null && (playerentity = world.getPlayerByUUID(((CurableConvertedCreature.Data)this.data()).conversationStarter)) instanceof ServerPlayer) {
            ((CuredVampireVillagerCriterionTrigger)((Object)ModAdvancements.TRIGGER_CURED_VAMPIRE_VILLAGER.get())).trigger((ServerPlayer)playerentity, (Entity)this, villager);
            world.onReputationEvent(ReputationEventType.ZOMBIE_VILLAGER_CURED, (Entity)playerentity, (ReputationEventHandler)villager);
        }
        return villager;
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        Player player;
        if (!this.level().isClientSide && this.wantsBlood() && entity instanceof Player && !Helper.isHunter(player = (Player)entity) && !UtilLib.canReallySee((LivingEntity)player, (LivingEntity)this, true)) {
            int amt = VampirePlayer.get(player).onBite(this);
            this.drinkBlood(amt, 0.7f, new DrinkBloodContext((LivingEntity)player));
            return true;
        }
        return super.doHurtTarget(entity);
    }

    @Override
    @NotNull
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    @NotNull
    public EntityDataAccessor<String> getSourceEntityDataParam() {
        return OVERLAY_TEXTURE;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
         @NotNull BloodDrinkEvent.EntityDrinkBloodEvent event = VampirismEventFactory.fireVampireDrinkBlood(this, amt, saturationMod, useRemaining, drinkContext);
        this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, event.getAmount() * 20));
        this.bloodTimer = -1200 - this.random.nextInt(1200);
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    public void handleEntityEventSuper(byte id) {
        super.handleEntityEvent(id);
    }

    @Override
    public InteractionResult mobInteractSuper(@NotNull Player player, @NotNull InteractionHand hand) {
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean hurtSuper(DamageSource damageSource, float amount) {
        return super.hurt(damageSource, amount);
    }

    @Override
    public boolean hurt(@NotNull DamageSource src, float amount) {
        return this.hurtC(src, amount);
    }

    @NotNull
    protected Component getTypeName() {
        ResourceLocation profName = RegUtil.id(this.getVillagerData().getProfession());
        return Component.translatable((String)(EntityType.VILLAGER.getDescriptionId() + "." + (String)(!"minecraft".equals(profName.getNamespace()) ? profName.getNamespace() + "." : "") + profName.getPath()));
    }

    public void handleEntityEvent(byte id) {
        if (!this.handleSound(id, (PathfinderMob)this)) {
            super.handleEntityEvent(id);
        }
    }

    @Override
    @NotNull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.level().getProfiler());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        return this.mobInteractC(player, hand);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readAdditionalSaveDataC(compound);
    }

    public void registerBrainGoals(@NotNull Brain<Villager> brain) {
        super.registerBrainGoals(brain);
        if (!this.isBaby()) {
            brain.setSchedule((Schedule)ModVillage.CONVERTED_DEFAULT.get());
            brain.updateActivityFromSchedule(this.level().getDayTime(), this.level().getGameTime());
        }
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, amt * 20));
        this.bloodTimer = 0;
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerConvertingData(builder);
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> dynamicIn) {
        Brain brain = Brain.provider(VillagerAccessor.getMemoryTypes(), SENSOR_TYPES).makeBrain(dynamicIn);
        this.registerBrainGoals((Brain<Villager>)brain);
        return brain;
    }

    protected void updateTrades() {
        super.updateTrades();
        if (!this.getOffers().isEmpty() && this.getRandom().nextInt(3) == 0) {
            this.addOffersFromItemListings(this.getOffers(), Trades.converted_trades, 1);
        }
    }

    @Override
    public CurableConvertedCreature.Data<Villager> data() {
        return this.convertedData;
    }

    public void die(@NotNull DamageSource pCause) {
        super.die(pCause);
        this.dieC(pCause);
    }

    protected void tickDeath() {
        super.tickDeath();
        this.tickDeathC();
    }

    static {
        CONVERTING = SynchedEntityData.defineId(ConvertedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        OVERLAY_TEXTURE = SynchedEntityData.defineId(ConvertedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        SENSOR_TYPES = Lists.newArrayList(VillagerAccessor.getSensorTypes());
        SENSOR_TYPES.remove(SensorType.VILLAGER_HOSTILES);
        SENSOR_TYPES.add((SensorType<? extends Sensor<? super Villager>>)((SensorType)ModAi.VAMPIRE_VILLAGER_HOSTILES.get()));
    }
}

