/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.entity.converted.CurableConvertedCreature;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class ConvertedCamelEntity
extends Camel
implements CurableConvertedCreature<Camel, ConvertedCamelEntity> {
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.defineId(ConvertedCamelEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.defineId(ConvertedCamelEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final CurableConvertedCreature.Data<Camel> data = new CurableConvertedCreature.Data();

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = AbstractHorse.createBaseHorseAttributes();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder2 = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder2.add(ModAttributes.SUNDAMAGE, 7.0);
    }

    public static boolean checkConvertedCamelSpawnRules(EntityType<? extends Animal> pGoat, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.getDifficulty() != Difficulty.PEACEFUL && Camel.checkAnimalSpawnRules(pGoat, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public ConvertedCamelEntity(@NotNull EntityType<? extends Camel> type, @NotNull Level worldIn) {
        super(type, worldIn);
        this.xpReward = 2;
    }

    @Override
    public CurableConvertedCreature.Data<Camel> data() {
        return this.data;
    }

    @Override
    public void handleEntityEventSuper(byte id) {
        super.handleEntityEvent(id);
    }

    @Override
    @NotNull
    public InteractionResult mobInteractSuper(@NotNull Player player, @NotNull InteractionHand hand) {
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean hurtSuper(@NotNull DamageSource damageSource, float amount) {
        return super.hurt(damageSource, amount);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addAdditionalSaveDataC(compound);
    }

    public void aiStep() {
        this.aiStepC(EntityType.CAMEL);
        super.aiStep();
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        this.dieC(cause);
    }

    @Override
    @NotNull
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    @NotNull
    public EntityDataAccessor<String> getSourceEntityDataParam() {
        return OVERLAY_TEXTURE;
    }

    @NotNull
    protected Component getTypeName() {
        return this.getNameC(() -> ((EntityType)EntityType.CAMEL).getDescription());
    }

    public boolean hurt(@NotNull DamageSource damageSource, float amount) {
        return this.hurtC(damageSource, amount);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        return this.mobInteractC(player, hand);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readAdditionalSaveDataC(compound);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTamed();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerConvertingData(builder);
    }

    protected void randomizeAttributes(RandomSource random) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.getMaxHealth() * 1.5);
    }

    public void registerGoals() {
        super.registerGoals();
        this.registerGoalsC();
    }

    protected void tickDeath() {
        this.tickDeathC();
        super.tickDeath();
    }

    public void tick() {
        super.tick();
        this.tickC();
    }
}

