/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.datamaps.IEntityBlood;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModDataMaps;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.datamaps.EntityBloodEntry;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiteableEntryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final Map<EntityType<?>, IEntityBlood> calculatedEntries = new HashMap();

    @NotNull
    public IEntityBlood calculate(@NotNull PathfinderMob creature) {
        if (!((Boolean)VampirismConfig.SERVER.autoCalculateEntityBlood.get()).booleanValue()) {
            return EntityBloodEntry.EMPTY;
        }
        EntityType type = creature.getType();
        ResourceLocation id = RegUtil.id(type);
        if (this.isEntityBlacklisted(creature)) {
            return EntityBloodEntry.EMPTY;
        }
        AABB bb = creature.getBoundingBox();
        double v = bb.maxX - bb.minX;
        v *= bb.maxY - bb.minY;
        v *= bb.maxZ - bb.minZ;
        if (creature.isBaby()) {
            v *= 8.0;
        }
        int blood = 0;
        if (v >= 0.3) {
            blood = (int)(v * 7.0);
            blood = Math.min(15, blood);
        }
        if (creature.getMaxHealth() > 50.0f) {
            blood = 0;
        }
        LOGGER.debug("Calculated size {} and blood value {} for entity {}", (Object)Float.valueOf((float)Math.round(v * 100.0) / 100.0f), (Object)blood, (Object)id);
        if (blood == 0) {
            return EntityBloodEntry.EMPTY;
        }
        return new EntityBloodEntry(blood);
    }

    @Nullable
    public IEntityBlood get(@NotNull PathfinderMob creature) {
        if (this.calculatedEntries.containsKey(creature.getType())) {
            return this.calculatedEntries.get(creature.getType());
        }
        return (IEntityBlood)BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)creature.getType()).getData(ModDataMaps.ENTITY_BLOOD_MAP);
    }

    @NotNull
    public IEntityBlood getOrCalculate(@NotNull PathfinderMob creature) {
        IEntityBlood entry = this.get(creature);
        if (entry == null) {
            entry = this.calculate(creature);
            this.calculatedEntries.put(creature.getType(), entry);
        }
        return entry;
    }

    private boolean isConfigBlackListed(@NotNull ResourceLocation id) {
        List list = (List)VampirismConfig.SERVER.blacklistedBloodEntity.get();
        return list.contains(id.toString());
    }

    private boolean isEntityBlacklisted(PathfinderMob creature) {
        if (!(creature instanceof Animal)) {
            return true;
        }
        if (creature instanceof IVampire) {
            return true;
        }
        EntityType type = creature.getType();
        if (type.getCategory() == MobCategory.MONSTER || type.getCategory() == MobCategory.WATER_CREATURE) {
            return true;
        }
        if (type.is(ModTags.Entities.VAMPIRE)) {
            return true;
        }
        return this.isConfigBlackListed(RegUtil.id(type));
    }
}

