/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.TotemHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import org.jetbrains.annotations.NotNull;

public class GolemTargetNonVillageFactionGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    private static final Map<IFaction<?>, Predicate<LivingEntity>> predicates = new HashMap();
    @NotNull
    private final IronGolem golem;
    private IFaction<?> faction;

    public GolemTargetNonVillageFactionGoal(@NotNull IronGolem creature) {
        super((Mob)creature, LivingEntity.class, 4, false, false, null);
        this.golem = creature;
    }

    public boolean canContinueToUse() {
        if (this.golem.tickCount % 16 == 0 && this.determineGolemFaction()) {
            return false;
        }
        return super.canContinueToUse();
    }

    public boolean canUse() {
        if (this.golem.tickCount < 20) {
            return false;
        }
        return super.canUse();
    }

    protected void findTarget() {
        this.determineGolemFaction();
        super.findTarget();
    }

    private boolean determineGolemFaction() {
        IFaction<IHunterPlayer> faction = VReference.HUNTER_FACTION;
        if (((Boolean)VampirismConfig.BALANCE.golemAttackNonVillageFaction.get()).booleanValue()) {
            Optional<TotemBlockEntity> tile = TotemHelper.getTotemNearPos((ServerLevel)this.golem.level(), this.golem.blockPosition(), true);
            faction = tile.map(TotemBlockEntity::getControllingFaction).orElse(VReference.HUNTER_FACTION);
        }
        if (faction != this.faction) {
            this.faction = faction;
            this.targetConditions.selector(predicates.computeIfAbsent(this.faction, faction1 -> VampirismAPI.factionRegistry().getPredicate((IFaction<?>)faction1, true, true, false, false, null)));
            return true;
        }
        return false;
    }
}

