/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class FollowAdvancedVampireGoal
extends Goal {
    protected final BasicVampireEntity entity;
    protected final double speed;
    private final int DIST = 20;
    private int delayCounter;

    public FollowAdvancedVampireGoal(BasicVampireEntity entity, double speed) {
        this.entity = entity;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        if (this.entity.getAdvancedLeader() == null) {
            return false;
        }
        double d0 = this.entity.distanceToSqr((Entity)this.entity.getAdvancedLeader().getRepresentingEntity());
        return d0 >= 20.0 && d0 <= 256.0;
    }

    public boolean canUse() {
        IEntityLeader leader = this.entity.getAdvancedLeader();
        if (leader != null) {
            return leader.getRepresentingEntity().isAlive() && this.entity.distanceToSqr((Entity)leader.getRepresentingEntity()) > 20.0;
        }
        List list = this.entity.getCommandSenderWorld().getEntitiesOfClass(VampireBaseEntity.class, this.entity.getBoundingBox().inflate(8.0, 4.0, 8.0), IEntityLeader.class::isInstance);
        double d0 = Double.MAX_VALUE;
        for (VampireBaseEntity entity1 : list) {
            double d1;
            IEntityLeader leader1 = (IEntityLeader)((Object)entity1);
            if (!entity1.isAlive() || leader1.getFollowingCount() >= leader1.getMaxFollowerCount() || !((d1 = this.entity.distanceToSqr((Entity)entity1)) <= d0)) continue;
            d0 = d1;
            leader = leader1;
        }
        if (leader == null) {
            return false;
        }
        this.entity.setAdvancedLeader(leader);
        leader.increaseFollowerCount();
        return this.entity.distanceToSqr((Entity)leader.getRepresentingEntity()) > 20.0;
    }

    public void start() {
        this.delayCounter = 0;
    }

    public void tick() {
        if (--this.delayCounter <= 0 && this.entity.getAdvancedLeader() != null) {
            this.delayCounter = 10;
            this.entity.getNavigation().moveTo((Entity)this.entity.getAdvancedLeader().getRepresentingEntity(), this.speed);
            this.entity.lookAt(EntityAnchorArgument.Anchor.EYES, this.entity.getAdvancedLeader().getRepresentingEntity().position().add(0.0, (double)this.entity.getAdvancedLeader().getRepresentingEntity().getEyeHeight(), 0.0));
        }
    }
}

