/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.NotNull;

public class BlindingBatEntity
extends Bat {
    private final TargetingConditions nonVampirePredicatePlayer = TargetingConditions.forCombat().selector(VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true).and(EntitySelector.NO_CREATIVE_OR_SPECTATOR));
    private final TargetingConditions nonVampirePredicate = TargetingConditions.forCombat().selector(e -> !Helper.isVampire((Entity)e));
    private boolean restrictLiveSpan;
    private boolean targeting;
    private boolean targetingMob = false;

    public static boolean spawnPredicate(@NotNull EntityType<? extends BlindingBatEntity> entityType, @NotNull LevelAccessor iWorld, MobSpawnType spawnReason, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        if (iWorld.getBiome(blockPos).is(ModTags.Biomes.IS_VAMPIRE_BIOME)) {
            return true;
        }
        if (blockPos.getY() >= iWorld.getSeaLevel()) {
            return false;
        }
        int i = iWorld.getMaxLocalRawBrightness(blockPos);
        int j = 4;
        if (random.nextBoolean()) {
            return false;
        }
        return i <= random.nextInt(j) && BlindingBatEntity.checkMobSpawnRules(entityType, (LevelAccessor)iWorld, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)random);
    }

    public BlindingBatEntity(@NotNull EntityType<? extends BlindingBatEntity> type, @NotNull Level worldIn) {
        super(type, worldIn);
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor worldIn, @NotNull MobSpawnType spawnReasonIn) {
        return worldIn.isUnobstructed((Entity)this, Shapes.create((AABB)this.getBoundingBox())) && worldIn.isUnobstructed((Entity)this) && !worldIn.containsAnyLiquid(this.getBoundingBox());
    }

    public void restrictLiveSpan() {
        this.restrictLiveSpan = true;
    }

    public void setTargeting() {
        this.targeting = true;
    }

    public void tick() {
        super.tick();
        if (this.restrictLiveSpan && this.tickCount > BalanceMobProps.mobProps.BLINDING_BAT_LIVE_SPAWN) {
            DamageHandler.hurtVanilla((Entity)this, DamageSources::magic, 10.0f);
        }
        if (!this.level().isClientSide) {
            List l = this.targetingMob ? this.level().getEntitiesOfClass(Monster.class, this.getBoundingBox()) : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox());
            boolean hit = false;
            for (LivingEntity e : l) {
                if (!e.isAlive() || Helper.isVampire((Entity)e)) continue;
                e.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, BalanceMobProps.mobProps.BLINDING_BAT_EFFECT_DURATION));
                hit = true;
            }
            if (this.targeting && hit) {
                DamageHandler.kill((Entity)this, 1000);
            }
        }
    }

    protected void customServerAiStep() {
        boolean t = false;
        if (this.targeting && this.tickCount > 40) {
            Vec3 diff;
            double dist;
            this.targetingMob = false;
            Player e = this.level().getNearestPlayer(this.nonVampirePredicatePlayer, (LivingEntity)this);
            if (e == null) {
                e = this.level().getNearestEntity(Monster.class, this.nonVampirePredicate, null, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(20.0));
                this.targetingMob = true;
            }
            if (e != null && (dist = (diff = e.position().add(0.0, (double)e.getEyeHeight(), 0.0).subtract(this.position())).length()) < 20.0) {
                Vec3 mov = diff.scale(0.15 / dist);
                this.setDeltaMovement(mov);
                float f = (float)(Mth.atan2((double)mov.z, (double)mov.x) * 57.2957763671875) - 90.0f;
                float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
                this.zza = 0.5f;
                this.setYRot(this.getYRot() + f1);
                t = true;
            }
        }
        if (!t) {
            super.customServerAiStep();
        }
    }

    public boolean canFreeze() {
        return false;
    }
}

