/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.datamaps;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class EntityExistsCondition
implements ICondition {
    public static MapCodec<EntityExistsCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("entity_type").forGetter(EntityExistsCondition::getEntityType)).apply((Applicative)builder, EntityExistsCondition::new));
    private final ResourceLocation entity_type;

    public EntityExistsCondition(String location) {
        this(ResourceLocation.parse((String)location));
    }

    public EntityExistsCondition(String namespace, String path) {
        this(VResourceLocation.loc(namespace, path));
    }

    public EntityExistsCondition(ResourceLocation entity_type) {
        this.entity_type = entity_type;
    }

    public boolean test(@NotNull ICondition.IContext context) {
        return BuiltInRegistries.ENTITY_TYPE.containsKey(this.entity_type);
    }

    @NotNull
    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public ResourceLocation getEntityType() {
        return this.entity_type;
    }

    public String toString() {
        return "entity_type_exists(\"" + String.valueOf(this.entity_type) + "\")";
    }
}

