/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ModEntitySelectors {
    private static final String FACTION = "vampirism:faction";
    private static final String LEVEL = "vampirism:level";
    private static final String MIN_LEVEL = "vampirism:minLevel";
    private static final String MAX_LEVEL = "vampirism:maxLevel";
    private static final DynamicCommandExceptionType FACTION_NOT_FOUND = new DynamicCommandExceptionType(p_208726_0_ -> Component.translatable((String)"command.vampirism.argument.faction.notfound", (Object[])new Object[]{p_208726_0_}));

    public static void registerSelectors() {
        EntitySelectorOptions.register((String)FACTION, parser -> {
            IFaction<?>[] factions;
            boolean invert = parser.shouldInvertValue();
            ResourceLocation factionID = ResourceLocation.parse((String)parser.getReader().readString());
            for (IFaction<?> f : factions = VampirismAPI.factionRegistry().getFactions()) {
                if (!f.getID().equals((Object)factionID)) continue;
                parser.addPredicate(input -> {
                    if (input instanceof IFactionEntity) {
                        boolean flag1 = f.equals(((IFactionEntity)input).getFaction());
                        return invert != flag1;
                    }
                    if (f instanceof IPlayableFaction && input instanceof Player) {
                        boolean flag1 = FactionPlayerHandler.get((Player)input).isInFaction(f);
                        return invert != flag1;
                    }
                    return invert;
                });
                return;
            }
            throw FACTION_NOT_FOUND.createWithContext((ImmutableStringReader)parser.getReader(), (Object)factionID);
        }, parser -> true, (Component)Component.translatable((String)"vampirism.argument.entity.options.faction.desc"));
        EntitySelectorOptions.register((String)LEVEL, parser -> {
            StringReader reader = parser.getReader();
            MinMaxBounds.Ints bound = MinMaxBounds.Ints.fromReader((StringReader)reader);
            if (!bound.min().isEmpty() && (Integer)bound.min().get() < 0 || !bound.max().isEmpty() && (Integer)bound.max().get() < 0) {
                throw EntitySelectorOptions.ERROR_LEVEL_NEGATIVE.createWithContext((ImmutableStringReader)reader);
            }
            parser.addPredicate(input -> {
                if (input instanceof Player) {
                    int level = FactionPlayerHandler.get((Player)input).getCurrentLevel();
                    return !(!bound.min().isEmpty() && (Integer)bound.min().get() > level || !bound.max().isEmpty() && (Integer)bound.max().get() < level);
                }
                return false;
            });
        }, parser -> true, (Component)Component.translatable((String)"vampirism.argument.entity.options.level.desc"));
    }
}

