/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.items.VampireSwordItem;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VampireSwordCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"sword").then(((LiteralArgumentBuilder)Commands.literal((String)"charge").requires(context -> context.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"charge_amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> VampireSwordCommand.setSwordCharged((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), FloatArgumentType.getFloat((CommandContext)context, (String)"charge_amount")))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> VampireSwordCommand.setSwordCharged((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"players"), FloatArgumentType.getFloat((CommandContext)context, (String)"charge_amount"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"trained").requires(context -> context.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"train_amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> VampireSwordCommand.setSwordTrained((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), FloatArgumentType.getFloat((CommandContext)context, (String)"train_amount")))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> VampireSwordCommand.setSwordTrained((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"players"), FloatArgumentType.getFloat((CommandContext)context, (String)"train_amount"))))));
    }

    private static int setSwordCharged(@NotNull CommandSourceStack commandSource, @NotNull Collection<ServerPlayer> players, float charge) {
        for (ServerPlayer player : players) {
            ItemStack held = player.getMainHandItem().copy();
            Item item = held.getItem();
            if (item instanceof VampireSwordItem) {
                VampireSwordItem sword = (VampireSwordItem)item;
                sword.setCharged(held, charge);
                player.setItemInHand(InteractionHand.MAIN_HAND, held);
                continue;
            }
            commandSource.sendSuccess(() -> Component.translatable((String)"command.vampirism.test.swordcharged.nosword"), false);
        }
        return 0;
    }

    private static int setSwordTrained(@NotNull CommandSourceStack commandSource, @NotNull Collection<ServerPlayer> players, float train) {
        for (ServerPlayer player : players) {
            ItemStack held = player.getMainHandItem().copy();
            Item item = held.getItem();
            if (item instanceof VampireSwordItem) {
                VampireSwordItem sword = (VampireSwordItem)item;
                sword.setTrained(held, (LivingEntity)player, train);
                player.setItemInHand(InteractionHand.MAIN_HAND, held);
                continue;
            }
            commandSource.sendSuccess(() -> Component.translatable((String)"command.vampirism.test.swordtrained.nosword"), false);
        }
        return 0;
    }
}

