/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class LevelUpCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"levelup").requires(context -> context.hasPermission(2))).executes(context -> LevelUpCommand.levelUp((CommandContext<CommandSourceStack>)context, Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entities()).executes(context -> LevelUpCommand.levelUp((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"player"))));
    }

    private static int levelUp(@NotNull CommandContext<CommandSourceStack> context, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            if (handler.getCurrentLevel() == 0) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.vampirism.base.levelup.nofaction", (Object[])new Object[]{players.size() > 1 ? player.getDisplayName() : "Player"}));
                continue;
            }
            if (handler.getCurrentLevel() == handler.getCurrentFaction().getHighestReachableLevel()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampirism.base.levelup.max", (Object[])new Object[]{players.size() > 1 ? player.getDisplayName() : "Player"}), true);
                continue;
            }
            if (handler.setFactionAndLevel(handler.getCurrentFaction(), handler.getCurrentLevel() + 1)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampirism.base.levelup.newlevel", (Object[])new Object[]{player.getName(), handler.getCurrentFaction().getName(), handler.getCurrentLevel()}), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)(players.size() > 1 ? Component.translatable((String)"command.vampirism.failed_to_execute.players", (Object[])new Object[]{player.getDisplayName()}) : Component.translatable((String)"command.vampirism.failed_to_execute")));
        }
        return 0;
    }
}

