/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.HunterMinionModel;
import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.vampirism.client.renderer.entity.layers.PlayerBodyOverlayLayer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class HunterMinionRenderer
extends DualBipedRenderer<HunterMinionEntity, HunterMinionModel<HunterMinionEntity>> {
    private final PlayerSkin @NotNull [] textures = this.gatherTextures("textures/entity/hunter", true);
    private final PlayerSkin @NotNull [] minionSpecificTextures = this.gatherTextures("textures/entity/minion/hunter", false);

    public HunterMinionRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        super(context, new HunterMinionModel(context.bakeLayer(ModEntitiesRender.GENERIC_BIPED), false), new HunterMinionModel(context.bakeLayer(ModEntitiesRender.GENERIC_BIPED_SLIM), true), 0.5f);
        this.addLayer(new PlayerBodyOverlayLayer<HunterMinionEntity, HunterMinionModel<HunterMinionEntity>>(this));
        this.addLayer((RenderLayer)new DualBipedRenderer.ArmorLayer((DualBipedRenderer)this, (RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_SLIM_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_SLIM_OUTER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
    }

    public int getHunterTextureCount() {
        return this.textures.length;
    }

    public int getMinionSpecificTextureCount() {
        return this.minionSpecificTextures.length;
    }

    @Override
    protected PlayerSkin determineTextureAndModel(@NotNull HunterMinionEntity entity) {
        return entity.hasMinionSpecificSkin() && this.minionSpecificTextures.length > 0 ? this.minionSpecificTextures[entity.getHunterType() % this.minionSpecificTextures.length] : this.textures[entity.getHunterType() % this.textures.length];
    }

    protected void scale(@NotNull HunterMinionEntity entityIn, @NotNull PoseStack matrixStackIn, float partialTickTime) {
        float s = entityIn.getScale();
        matrixStackIn.scale(s, s, s);
    }

    protected void renderNameTag(@NotNull HunterMinionEntity pEntity, @NotNull Component pDisplayName, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, float partialTicks) {
        pMatrixStack.pushPose();
        pMatrixStack.translate(0.0f, 0.4f, 0.0f);
        super.renderNameTag((Entity)pEntity, pDisplayName, pMatrixStack, pBuffer, pPackedLight, partialTicks);
        pMatrixStack.popPose();
    }
}

