/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.client.renderer.blockentity.VampirismBESR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TotemBESR
extends VampirismBESR<TotemBlockEntity> {
    private static final ResourceLocation TEXTURE_BEACON_BEAM = VResourceLocation.mod("textures/entity/totem_beam.png");
    private static final int HEIGHT = 100;

    public TotemBESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull TotemBlockEntity te, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int i, int i1) {
        float textureScale = te.shouldRenderBeam();
        if (textureScale > 0.0f) {
            long totalWorldTime = te.getLevel().getGameTime();
            int captureProgress = te.getCaptureProgress();
            int baseColors = te.getBaseColor();
            int offset = 0;
            if (captureProgress > 0) {
                int color = te.getCapturingColors();
                offset = captureProgress * 100 / 100;
                BeaconRenderer.renderBeaconBeam((PoseStack)matrixStack, (MultiBufferSource)iRenderTypeBuffer, (ResourceLocation)TEXTURE_BEACON_BEAM, (float)partialTicks, (float)textureScale, (long)totalWorldTime, (int)0, (int)offset, (int)color, (float)0.2f, (float)0.25f);
            }
            BeaconRenderer.renderBeaconBeam((PoseStack)matrixStack, (MultiBufferSource)iRenderTypeBuffer, (ResourceLocation)TEXTURE_BEACON_BEAM, (float)partialTicks, (float)textureScale, (long)totalWorldTime, (int)offset, (int)(100 - offset), (int)baseColors, (float)0.2f, (float)0.25f);
        } else {
            IFaction<?> faction = te.getControllingFaction();
            if (faction != null) {
                this.renderFactionName(faction, matrixStack, iRenderTypeBuffer, i);
            }
        }
    }

    public boolean shouldRenderOffScreen(@NotNull TotemBlockEntity te) {
        return true;
    }

    private void renderFactionName(@NotNull IFaction<?> faction, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int packedLight) {
        MutableComponent displayNameIn = faction.getNamePlural().plainCopy().withStyle(style -> style.withColor(faction.getChatColor()));
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.0, 0.5);
        matrixStack.mulPose(Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
        matrixStack.scale(-0.025f, -0.025f, -0.025f);
        Matrix4f matrix4f = matrixStack.last().pose();
        float f1 = 0.0f;
        int j = (int)(f1 * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float nameOffset = -font.width((FormattedText)displayNameIn) / 2;
        font.drawInBatch((Component)displayNameIn, nameOffset, 0.0f, 0x20FFFFFF, false, matrix4f, iRenderTypeBuffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
        font.drawInBatch((Component)displayNameIn, nameOffset, 0.0f, -1, false, matrix4f, iRenderTypeBuffer, Font.DisplayMode.SEE_THROUGH, 0, packedLight);
        matrixStack.popPose();
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull TotemBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

