/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blockentity.CoffinBlockEntity;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.client.renderer.blockentity.VampirismBESR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class CoffinBESR
extends VampirismBESR<CoffinBlockEntity> {
    private static final Marker COFFIN = new MarkerManager.Log4jMarker("COFFIN");
    private final Logger LOGGER = LogManager.getLogger();

    public CoffinBESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull CoffinBlockEntity tile, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int i, int i1) {
        BlockState state = tile.getBlockState();
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (!this.isHeadSafe(tile.getLevel(), tile.getBlockPos())) {
            return;
        }
        matrixStack.pushPose();
        boolean vertical = (Boolean)state.getValue((Property)CoffinBlock.VERTICAL);
        switch (direction) {
            case EAST: {
                if (vertical) {
                    matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    matrixStack.translate(0.0f, -1.0f, 0.0f);
                }
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                matrixStack.translate(-1.0f, 0.0f, -1.0f);
                break;
            }
            case WEST: {
                if (vertical) {
                    matrixStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                    matrixStack.translate(-1.0f, 0.0f, 0.0f);
                }
                matrixStack.mulPose(Axis.YN.rotationDegrees(90.0f));
                matrixStack.translate(0.0f, 0.0f, -2.0f);
                break;
            }
            case SOUTH: {
                if (vertical) {
                    matrixStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                    matrixStack.translate(0.0f, -1.0f, 0.0f);
                }
                matrixStack.translate(0.0f, 0.0f, -1.0f);
                break;
            }
            case NORTH: {
                if (vertical) {
                    matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    matrixStack.translate(0.0f, 0.0f, -1.0f);
                }
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrixStack.translate(-1.0f, 0.0f, -2.0f);
            }
        }
        BakedModel baseModel = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/coffin/coffin_bottom_" + tile.color.getName())));
        ModelData modelData = baseModel.getModelData((BlockAndTintGetter)tile.getLevel(), tile.getBlockPos(), state, ModelData.EMPTY);
        for (RenderType renderType : baseModel.getRenderTypes(state, RandomSource.create((long)42L), modelData)) {
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrixStack.last(), iRenderTypeBuffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), state, baseModel, 1.0f, 1.0f, 1.0f, i, i1, modelData, renderType);
        }
        matrixStack.pushPose();
        if (vertical) {
            matrixStack.mulPose(Axis.ZP.rotationDegrees(80.0f * tile.lidPos));
            matrixStack.translate(0.0, -0.5 * (double)tile.lidPos, 0.0);
        } else {
            matrixStack.mulPose(Axis.YN.rotationDegrees(35.0f * tile.lidPos));
            matrixStack.translate(0.0, 0.0, -0.5 * (double)tile.lidPos);
        }
        BakedModel lidModel = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/coffin/coffin_top_" + tile.color.getName())));
        modelData = lidModel.getModelData((BlockAndTintGetter)tile.getLevel(), tile.getBlockPos(), state, ModelData.EMPTY);
        for (RenderType renderType : lidModel.getRenderTypes(state, RandomSource.create((long)42L), modelData)) {
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrixStack.last(), iRenderTypeBuffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), state, lidModel, 1.0f, 1.0f, 1.0f, i, i1, modelData, renderType);
        }
        matrixStack.popPose();
        matrixStack.popPose();
    }

    private boolean isHeadSafe(@NotNull Level world, @NotNull BlockPos pos) {
        try {
            return CoffinBlock.isHead((BlockGetter)world, pos);
        }
        catch (IllegalArgumentException e) {
            this.LOGGER.error(COFFIN, "Failed to check coffin head at {} caused by wrong blockstate. Block at that pos: {}", (Object)pos, (Object)world.getBlockState(pos));
        }
        catch (Exception e) {
            this.LOGGER.error(COFFIN, "Failed to check coffin head at " + String.valueOf(pos) + ".", (Throwable)e);
        }
        return false;
    }

    @NotNull
    public AABB getRenderBoundingBox(CoffinBlockEntity blockEntity) {
        BlockPos worldPosition = blockEntity.getBlockPos();
        return new AABB((double)(worldPosition.getX() - 4), (double)worldPosition.getY(), (double)(worldPosition.getZ() - 4), (double)(worldPosition.getX() + 4), (double)(worldPosition.getY() + 2), (double)(worldPosition.getZ() + 4));
    }
}

