/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.armor;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.armor.VampirismArmorModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.jetbrains.annotations.NotNull;

public class VampireHatModel
extends VampirismArmorModel {
    private static final String BASE = "base";
    private static final String TOP = "top";
    private static VampireHatModel instance;
    @NotNull
    public final ModelPart base;
    @NotNull
    public final ModelPart top;

    public static VampireHatModel getAdjustedInstance(HumanoidModel<?> wearerModel) {
        if (instance == null) {
            instance = new VampireHatModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModEntitiesRender.CLOTHING_HAT));
        }
        instance.copyFromHumanoid(wearerModel);
        return instance;
    }

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        CubeDeformation def = new CubeDeformation(0.25f);
        PartDefinition base = part.addOrReplaceChild(BASE, CubeListBuilder.create().texOffs(16, 0).addBox(-4.5f, -8.4f, -3.5f, 7.0f, 0.4f, 7.0f, def), PartPose.ZERO);
        base.addOrReplaceChild(TOP, CubeListBuilder.create().addBox(-0.6f, -14.5f, -3.0f, 4.0f, 7.0f, 4.0f, def), PartPose.rotation((float)-0.22217305f, (float)0.0f, (float)-0.27750733f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public VampireHatModel(@NotNull ModelPart part) {
        this.base = part.getChild(BASE);
        this.top = this.base.getChild(TOP);
    }

    @Override
    @NotNull
    protected Iterable<ModelPart> getHeadModels() {
        return ImmutableList.of((Object)this.base);
    }
}

