/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.armor;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.armor.VampirismArmorModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.jetbrains.annotations.NotNull;

public class ClothingBootsModel
extends VampirismArmorModel {
    private static final String RIGHT_BOOT = "right_boot";
    private static final String RIGHT_TOES = "right_toes";
    private static final String LEFT_BOOT = "left_boot";
    private static final String LEFT_TOES = "left_toes";
    private static ClothingBootsModel instance;
    @NotNull
    public final ModelPart rightBoot;
    @NotNull
    public final ModelPart leftBoot;
    @NotNull
    public final ModelPart leftToes;
    @NotNull
    public final ModelPart rightToes;

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        CubeDeformation scale = new CubeDeformation(0.4f);
        part.addOrReplaceChild(RIGHT_BOOT, CubeListBuilder.create().addBox(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, scale), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        part.addOrReplaceChild(RIGHT_TOES, CubeListBuilder.create().texOffs(2, 9).addBox(-2.0f, 10.0f, -4.0f, 4.0f, 2.0f, 2.0f, scale), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        part.addOrReplaceChild(LEFT_BOOT, CubeListBuilder.create().texOffs(16, 0).addBox(-2.0f, 7.0f, -2.0f, 4.0f, 5.0f, 4.0f, scale), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        part.addOrReplaceChild(LEFT_TOES, CubeListBuilder.create().texOffs(18, 9).addBox(-2.0f, 10.0f, -4.0f, 4.0f, 2.0f, 2.0f, scale), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)16);
    }

    public static ClothingBootsModel getAdjustedInstance(HumanoidModel<?> wearerModel) {
        if (instance == null) {
            instance = new ClothingBootsModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModEntitiesRender.CLOTHING_BOOTS));
        }
        instance.copyFromHumanoid(wearerModel);
        return instance;
    }

    public ClothingBootsModel(@NotNull ModelPart part) {
        this.rightBoot = part.getChild(RIGHT_BOOT);
        this.rightToes = part.getChild(RIGHT_TOES);
        this.leftBoot = part.getChild(LEFT_BOOT);
        this.leftToes = part.getChild(LEFT_TOES);
    }

    @Override
    @NotNull
    protected Iterable<ModelPart> getLeftLegModels() {
        return ImmutableList.of((Object)this.leftBoot, (Object)this.leftToes);
    }

    @Override
    @NotNull
    protected Iterable<ModelPart> getRightLegModels() {
        return ImmutableList.of((Object)this.rightBoot, (Object)this.rightToes);
    }
}

