/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class WingModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private static final String WING_RIGHT = "wing_right";
    private static final String WING_RIGHT2 = "wing_right2";
    private static final String WING_LEFT = "wing_left";
    private static final String WING_LEFT2 = "wing_left2";
    @NotNull
    public final ModelPart wingRight;
    @NotNull
    public final ModelPart wingLeft;
    @NotNull
    public final ModelPart wingRight2;
    @NotNull
    public final ModelPart wingLeft2;

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        PartDefinition wingr = part.addOrReplaceChild(WING_RIGHT, CubeListBuilder.create().texOffs(0, 46).addBox(-18.0f, -6.0f, 0.0f, 18.0f, 18.0f, 0.0f), PartPose.offsetAndRotation((float)0.2f, (float)2.5f, (float)2.0f, (float)0.13665928f, (float)0.5462881f, (float)0.27314404f));
        wingr.addOrReplaceChild(WING_RIGHT2, CubeListBuilder.create().texOffs(0, 28).addBox(-16.0f, -4.0f, 0.0f, 16.0f, 18.0f, 0.0f), PartPose.offsetAndRotation((float)-18.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.8196066f, (float)0.0f));
        PartDefinition wingl = part.addOrReplaceChild(WING_LEFT, CubeListBuilder.create().texOffs(0, 46).mirror().addBox(0.0f, -6.0f, 0.0f, 18.0f, 18.0f, 0.0f), PartPose.offsetAndRotation((float)-0.2f, (float)-2.5f, (float)2.0f, (float)0.13665928f, (float)-0.63739425f, (float)-0.27314404f));
        wingl.addOrReplaceChild(WING_LEFT2, CubeListBuilder.create().texOffs(0, 28).mirror().addBox(0.0f, -4.0f, 0.0f, 16.0f, 18.0f, 0.0f), PartPose.offsetAndRotation((float)18.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.8196066f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public WingModel(@NotNull ModelPart part) {
        this.wingRight = part.getChild(WING_RIGHT);
        this.wingRight2 = this.wingRight.getChild(WING_RIGHT2);
        this.wingLeft = part.getChild(WING_LEFT);
        this.wingLeft2 = this.wingLeft.getChild(WING_LEFT2);
    }

    public void copyRotationFromBody(@NotNull ModelPart body) {
        this.wingLeft.yRot = body.yRot;
        this.wingLeft2.yRot = body.yRot;
        this.wingRight.yRot = body.yRot;
        this.wingRight2.yRot = body.yRot;
        this.wingLeft.xRot = body.xRot;
        this.wingRight.xRot = body.xRot;
        this.wingLeft.zRot = body.zRot;
        this.wingRight.zRot = body.zRot;
    }

    public void prepareMobModel(@NotNull T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (entityIn.isShiftKeyDown()) {
            this.wingRight.y = 3.0f;
            this.wingLeft.y = 3.0f;
        } else {
            this.wingRight.y = 2.5f;
            this.wingLeft.y = 2.5f;
        }
        this.wingLeft.zRot -= (float)((double)Mth.cos((float)(((float)((LivingEntity)entityIn).tickCount + partialTick) * 0.0662f + (float)Math.PI)) * 0.06);
        this.wingRight.zRot += (float)((double)Mth.cos((float)(((float)((LivingEntity)entityIn).tickCount + partialTick) * 0.0662f + (float)Math.PI)) * 0.06);
        this.wingLeft.yRot -= 0.3f;
        this.wingRight.yRot += 0.3f;
    }

    public void setRotateAngle(@NotNull ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.xRot = x;
        ModelRenderer.yRot = y;
        ModelRenderer.zRot = z;
    }

    public void setupAnim(@NotNull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.wingLeft, (Object)this.wingRight);
    }

    @NotNull
    protected HumanoidArm getSwingingSide(@NotNull T entity) {
        HumanoidArm handside = entity.getMainArm();
        return ((LivingEntity)entity).swingingArm == InteractionHand.MAIN_HAND ? handside : handside.getOpposite();
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return Collections.emptyList();
    }
}

