/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class BipedCloakedModel<T extends LivingEntity>
extends PlayerModel<T> {
    private static final String CLOAK = "cloak";
    @NotNull
    protected final ModelPart bipedCloak;

    @NotNull
    public static MeshDefinition createMesh(boolean smallArms) {
        MeshDefinition var2 = PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)smallArms);
        PartDefinition var3 = var2.getRoot();
        var3.addOrReplaceChild(CLOAK, CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, 0.0f, 2.0f, 14.0f, 20.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        return var2;
    }

    public BipedCloakedModel(@NotNull ModelPart part, boolean smallArms) {
        super(part, smallArms);
        this.bipedCloak = part.getChild(CLOAK);
    }

    public void renderCustomCloak(@NotNull PoseStack matrixStackIn, @NotNull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn) {
        this.bipedCloak.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setAllVisible(boolean visible) {
        super.setAllVisible(visible);
        this.bipedCloak.visible = visible;
    }

    public void setupAnim(@NotNull T entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.setupAnim(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        float f = 1.0f;
        if (entity.getFallFlyingTicks() > 4) {
            f = (float)entity.getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.bipedCloak.y = entity.isCrouching() ? 2.0f : 0.0f;
        this.bipedCloak.xRot = Math.max(Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount / f, Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount / f);
    }
}

