/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class BaronessModel
extends AgeableListModel<VampireBaronEntity>
implements HeadedModel,
ArmedModel {
    private static final String BODY = "body";
    private static final String HEAD_OVERLAY = "head_overlay";
    private static final String LEG_RIGHT_OVERLAY = "leg_right_overlay";
    private static final String LEG_LEFT_OVERLAY = "leg_left_overlay";
    private static final String ARM_RIGHT_OVERLAY = "arm_right_overlay";
    private static final String ARM_LEFT_OVERLAY = "arm_left_overlay";
    private static final String BODY_OVERLAY = "body_overlay";
    private static final String HEAD = "head";
    private static final String ARM_RIGHT = "arm_right";
    private static final String ARM_LEFT = "arm_left";
    private static final String LEG_RIGHT = "leg_right";
    private static final String LEG_LEFT = "leg_left";
    private static final String CLAWS_RIGHT = "claws_right";
    private static final String CLAWS_LEFT = "claws_left";
    @NotNull
    public final ModelPart body;
    @NotNull
    public final ModelPart headOverlay;
    @NotNull
    public final ModelPart legRightOverlay;
    @NotNull
    public final ModelPart legLeftOverlay;
    @NotNull
    public final ModelPart armRightOverlay;
    @NotNull
    public final ModelPart bodyOverlay;
    @NotNull
    public final ModelPart armLeftOverlay;
    @NotNull
    public final ModelPart head;
    @NotNull
    public final ModelPart armRight;
    @NotNull
    public final ModelPart armLeft;
    @NotNull
    public final ModelPart legRight;
    @NotNull
    public final ModelPart legLeft;
    @NotNull
    public final ModelPart clawsRight;
    @NotNull
    public final ModelPart clawsLeft;
    protected final HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    protected final HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        CubeDeformation DEFORM_OVERLAY = new CubeDeformation(0.2f);
        PartDefinition body = part.addOrReplaceChild(BODY, CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.ZERO);
        part.addOrReplaceChild(LEG_RIGHT_OVERLAY, CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        part.addOrReplaceChild(ARM_LEFT_OVERLAY, CubeListBuilder.create().texOffs(48, 48).addBox(0.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        body.addOrReplaceChild(LEG_LEFT, CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        part.addOrReplaceChild(HEAD_OVERLAY, CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        PartDefinition armLeft = body.addOrReplaceChild(ARM_LEFT, CubeListBuilder.create().texOffs(32, 48).addBox(0.0f, -1.5f, -2.0f, 3.0f, 12.0f, 4.0f), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        armLeft.addOrReplaceChild(CLAWS_LEFT, CubeListBuilder.create().texOffs(24, 0).addBox(-4.0f, 0.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.ZERO);
        body.addOrReplaceChild(HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        PartDefinition armRight = body.addOrReplaceChild(ARM_RIGHT, CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -1.5f, -2.0f, 3.0f, 12.0f, 4.0f), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        armRight.addOrReplaceChild(CLAWS_RIGHT, CubeListBuilder.create().texOffs(24, 0).addBox(1.0f, -1.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.ZERO);
        part.addOrReplaceChild(LEG_LEFT_OVERLAY, CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        part.addOrReplaceChild(ARM_RIGHT_OVERLAY, CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        part.addOrReplaceChild(BODY_OVERLAY, CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, DEFORM_OVERLAY), PartPose.ZERO);
        body.addOrReplaceChild(LEG_RIGHT, CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public BaronessModel(@NotNull ModelPart part) {
        this.body = part.getChild(BODY);
        this.headOverlay = part.getChild(HEAD_OVERLAY);
        this.legRightOverlay = part.getChild(LEG_RIGHT_OVERLAY);
        this.legLeftOverlay = part.getChild(LEG_LEFT_OVERLAY);
        this.armRightOverlay = part.getChild(ARM_RIGHT_OVERLAY);
        this.armLeftOverlay = part.getChild(ARM_LEFT_OVERLAY);
        this.bodyOverlay = part.getChild(BODY_OVERLAY);
        this.head = this.body.getChild(HEAD);
        this.armRight = this.body.getChild(ARM_RIGHT);
        this.armLeft = this.body.getChild(ARM_LEFT);
        this.legRight = this.body.getChild(LEG_RIGHT);
        this.legLeft = this.body.getChild(LEG_LEFT);
        this.clawsLeft = this.armLeft.getChild(CLAWS_LEFT);
        this.clawsRight = this.armRight.getChild(CLAWS_RIGHT);
    }

    @NotNull
    public ModelPart getHead() {
        return this.head;
    }

    public void setupAnim(@NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.body.yRot = 0.0f;
        this.armRight.z = 0.0f;
        this.armRight.x = -4.0f;
        this.armLeft.z = 0.0f;
        this.armLeft.x = 4.0f;
        this.armRight.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.armLeft.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.armRight.zRot = 0.0f;
        this.armLeft.zRot = 0.0f;
        this.legRight.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legLeft.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.legRight.yRot = 0.0f;
        this.legLeft.yRot = 0.0f;
        this.legRight.zRot = 0.0f;
        this.legLeft.zRot = 0.0f;
        this.armRight.yRot = 0.0f;
        this.armRight.zRot = 0.0f;
        switch (this.leftArmPose) {
            case EMPTY: {
                this.armLeft.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                this.armLeft.xRot = this.armLeft.xRot * 0.5f - 0.9424779f;
                this.armLeft.yRot = 0.5235988f;
                break;
            }
            case ITEM: {
                this.armLeft.xRot = this.armLeft.xRot * 0.5f - 0.31415927f;
                this.armLeft.yRot = 0.0f;
            }
        }
        switch (this.rightArmPose) {
            case EMPTY: {
                this.armRight.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                this.armRight.xRot = this.armRight.xRot * 0.5f - 0.9424779f;
                this.armRight.yRot = -0.5235988f;
                break;
            }
            case ITEM: {
                this.armRight.xRot = this.armRight.xRot * 0.5f - 0.31415927f;
                this.armRight.yRot = 0.0f;
            }
        }
        if (this.attackTime > 0.0f) {
            HumanoidArm handside = this.getSwingingSide(entityIn);
            ModelPart ModelRenderer = this.getArmForSide(handside);
            float f1 = this.attackTime;
            this.body.yRot = Mth.sin((float)(Mth.sqrt((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HumanoidArm.LEFT) {
                this.body.yRot *= -1.0f;
            }
            this.armRight.x = -Mth.cos((float)this.body.yRot) * 4.0f;
            this.armLeft.x = Mth.cos((float)this.body.yRot) * 4.0f;
            this.armLeft.xRot += this.body.yRot;
            f1 = 1.0f - this.attackTime;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = Mth.sin((float)(f1 * (float)Math.PI));
            float f3 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            ModelRenderer.xRot = (float)((double)ModelRenderer.xRot - ((double)f2 * 1.2 + (double)f3));
        }
        this.body.xRot = 0.0f;
        this.legRight.z = 0.1f;
        this.legLeft.z = 0.1f;
        this.legRight.y = 12.0f;
        this.legLeft.y = 12.0f;
        this.head.y = 0.0f;
        this.armRight.xRot += (float)((double)(Mth.sin((float)(ageInTicks * 0.067f)) * 0.06f) - 0.03);
        this.armLeft.xRot -= (float)((double)(Mth.sin((float)(ageInTicks * 0.067f)) * 0.06f) + 0.03);
        this.headOverlay.copyFrom(this.head);
        this.armLeftOverlay.copyFrom(this.armLeft);
        this.armRightOverlay.copyFrom(this.armRight);
        this.clawsLeft.copyFrom(this.armLeft);
        this.clawsLeft.y += 8.5f;
        this.clawsRight.copyFrom(this.armRight);
        this.clawsRight.y += 9.5f;
    }

    public void translateToHand(@NotNull HumanoidArm sideIn, @NotNull PoseStack matrixStackIn) {
        this.getArmForSide(sideIn).translateAndRotate(matrixStackIn);
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.armLeft : this.armRight;
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.headOverlay, (Object)this.bodyOverlay, (Object)this.armLeftOverlay, (Object)this.armRightOverlay, (Object)this.legLeftOverlay, (Object)this.legRightOverlay);
    }

    @NotNull
    protected HumanoidArm getSwingingSide(@NotNull VampireBaronEntity entity) {
        HumanoidArm handside = entity.getMainArm();
        return entity.swingingArm == InteractionHand.MAIN_HAND ? handside : handside.getOpposite();
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }
}

