/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class BaronAttireModel
extends EntityModel<VampireBaronEntity> {
    private static final String HOOD = "hood";
    private static final String CLOAK = "cloak";
    @NotNull
    public final ModelPart hood;
    @NotNull
    public final ModelPart cloak;
    private float enragedProgress = 0.0f;

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        PartDefinition hood = part.addOrReplaceChild(HOOD, CubeListBuilder.create().texOffs(44, 0).addBox(-4.5f, -8.5f, -4.0f, 9.0f, 9.0f, 9.0f), PartPose.ZERO);
        hood.addOrReplaceChild(CLOAK, CubeListBuilder.create().texOffs(0, 0).addBox(-8.5f, -0.5f, -2.5f, 17.0f, 22.0f, 5.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public BaronAttireModel(@NotNull ModelPart part) {
        this.hood = part.getChild(HOOD);
        this.cloak = this.hood.getChild(CLOAK);
    }

    public void prepareMobModel(@NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.enragedProgress = entityIn.getEnragedProgress();
    }

    public void renderToBuffer(@NotNull PoseStack matrixStackIn, @NotNull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.hood.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        matrixStackIn.pushPose();
        matrixStackIn.scale(1.0f - 0.4f * this.enragedProgress, 1.0f - 0.7f * this.enragedProgress, 1.0f - 0.4f * this.enragedProgress);
        this.cloak.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        matrixStackIn.popPose();
    }

    public void setupAnim(@NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float bodyRotateAngleY = 0.0f;
        if (this.attackTime > 0.0f) {
            HumanoidArm handside = this.getSwingingSide(entityIn);
            float f1 = this.attackTime;
            bodyRotateAngleY = Mth.sin((float)(Mth.sqrt((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HumanoidArm.LEFT) {
                bodyRotateAngleY *= -1.0f;
            }
        }
        this.hood.yRot = bodyRotateAngleY;
        this.cloak.yRot = bodyRotateAngleY;
    }

    @NotNull
    protected HumanoidArm getSwingingSide(@NotNull VampireBaronEntity entity) {
        HumanoidArm handside = entity.getMainArm();
        return entity.swingingArm == InteractionHand.MAIN_HAND ? handside : handside.getOpposite();
    }
}

