/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.skills;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsTabScreen;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.data.ClientSkillTreeData;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import de.teamlapen.vampirism.network.ServerboundUnlockSkillPacket;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class SkillsScreen
extends Screen {
    public static final int SCREEN_WIDTH = 252;
    public static final int SCREEN_HEIGHT = 219;
    private static final ResourceLocation WINDOW_LOCATION = VResourceLocation.mod("textures/gui/skills/window.png");
    private static final ResourceLocation TABS_LOCATION = VResourceLocation.mc("textures/gui/advancements/tabs.png");
    private static final Component VERY_SAD_LABEL = Component.translatable((String)"advancements.sad_label");
    private static final Component NO_TABS_LABEL = Component.translatable((String)"gui.vampirism.skill_screen.no_tab");
    private static final Component TITLE = Component.translatable((String)"gui.vampirism.vampirism_menu.skill_screen");
    @Nullable
    private final IFactionPlayer<?> factionPlayer;
    private final List<SkillsTabScreen> tabs = new ArrayList<SkillsTabScreen>();
    @Nullable
    private final Screen backScreen;
    @Nullable
    private SkillsTabScreen selectedTab;
    @Nullable
    private Button resetSkills;
    private int guiLeft;
    private int guiTop;
    private boolean scrolling;
    @Nullable
    private Vec3 mousePos;
    private boolean clicked;

    public SkillsScreen(@Nullable IFactionPlayer<?> factionPlayer, @Nullable Screen backScreen) {
        super(GameNarrator.NO_TITLE);
        this.factionPlayer = factionPlayer;
        this.backScreen = backScreen;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        assert (this.minecraft != null);
        this.tabs.clear();
        this.guiLeft = (this.width - 252) / 2;
        this.guiTop = (this.height - 219) / 2;
        if (this.factionPlayer != null) {
            int index = 0;
            SkillHandler skillHandler = (SkillHandler)this.factionPlayer.getSkillHandler();
            for (Holder<ISkillTree> unlockedSkillTree : skillHandler.unlockedSkillTrees()) {
                this.tabs.add(new SkillsTabScreen(this.minecraft, this, index++, unlockedSkillTree, this.factionPlayer.getSkillHandler(), (ClientSkillTreeData)skillHandler.getTreeData()));
            }
        }
        if (!this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.get(this.selectedTab == null ? 0 : this.selectedTab.getIndex());
        }
        if (this.backScreen != null) {
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 4, this.guiTop + 194, 80, 20, (Component)Component.translatable((String)"gui.back"), context -> this.minecraft.setScreen(this.backScreen)));
        }
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 168, this.guiTop + 194, 80, 20, (Component)Component.translatable((String)"gui.done"), context -> this.minecraft.setScreen(null)));
        FactionPlayerHandler.get((Player)this.minecraft.player).getCurrentFactionPlayer().ifPresent(factionPlayer -> {
            boolean test = VampirismMod.inDev || REFERENCE.VERSION.isTestVersion();
            this.resetSkills = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 85, this.guiTop + 194, 80, 20, (Component)Component.translatable((String)"text.vampirism.skill.resetall"), context -> {
                VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.RESET_SKILLS));
                InventoryHelper.removeItemFromInventory((Container)factionPlayer.asEntity().getInventory(), new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get()));
                if (!(factionPlayer.getLevel() >= 2 && this.minecraft.player.getInventory().countItem((Item)ModItems.OBLIVION_POTION.get()) > 1 || test)) {
                    context.active = false;
                }
            }));
            if (!(factionPlayer.getLevel() >= 2 && this.minecraft.player.getInventory().countItem((Item)ModItems.OBLIVION_POTION.get()) > 0 || test)) {
                this.resetSkills.active = false;
                this.resetSkills.setTooltip(Tooltip.create((Component)Component.translatable((String)"text.vampirism.skills.reset_consume", (Object[])new Object[]{((OblivionItem)((Object)((Object)ModItems.OBLIVION_POTION.get()))).getDescription()})));
            } else {
                this.resetSkills.setTooltip(Tooltip.create((Component)Component.translatable((String)"text.vampirism.skills.reset_req", (Object[])new Object[]{((OblivionItem)((Object)((Object)ModItems.OBLIVION_POTION.get()))).getDescription()})));
            }
        });
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.renderInside(graphics, mouseX, mouseY, this.guiLeft, this.guiTop);
        this.renderWindow(graphics, mouseX, mouseY, this.guiLeft, this.guiTop);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.renderTooltip(graphics, mouseX, mouseY, this.guiLeft, this.guiTop);
    }

    public void renderInside(@NotNull GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        PoseStack pose = graphics.pose();
        if (this.selectedTab != null) {
            this.selectedTab.drawContents(graphics, x + 9, y + 18, mouseX - 9 - this.guiLeft, mouseY - 18 - this.guiTop);
        } else {
            pose.pushPose();
            pose.translate((float)(x + 9), (float)(y + 18), 0.0f);
            graphics.fill(0, 0, 234, 192, -16777216);
            int i = 117;
            graphics.drawCenteredString(this.font, NO_TABS_LABEL, i, 52, -1);
            graphics.drawCenteredString(this.font, VERY_SAD_LABEL, i, 104, -1);
            pose.popPose();
        }
    }

    public void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(WINDOW_LOCATION, x, y, 0, 0, 252, 219);
        if (this.tabs.size() > 1) {
            for (SkillsTabScreen skillTab : this.tabs) {
                skillTab.drawTab(graphics, x, y, skillTab == this.selectedTab);
            }
            for (SkillsTabScreen skillTab : this.tabs) {
                skillTab.drawIcon(graphics, x, y);
            }
        }
        if (this.selectedTab != null) {
            int remainingPoints1 = this.selectedTab.getRemainingPoints();
            MutableComponent remainingPoints = remainingPoints1 == Integer.MAX_VALUE ? Component.translatable((String)"text.vampirism.skills.points_left", (Object[])new Object[]{"\u221e"}) : Component.translatable((String)"text.vampirism.skills.points_left", (Object[])new Object[]{String.valueOf(remainingPoints1)});
            graphics.drawString(this.font, (Component)remainingPoints, x + 240 - this.font.width((FormattedText)remainingPoints), y + 6, 0x404040, false);
        }
        graphics.drawString(this.font, TITLE, x + 8, y + 6, 0x404040, false);
    }

    public void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (this.minecraft.player.getEffect(ModEffects.OBLIVION) != null) {
            return;
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.selectedTab != null) {
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate((float)(guiLeft + 9), (float)(guiTop + 18), 400.0f);
            this.selectedTab.drawTooltips(graphics, mouseX - guiLeft - 9, mouseY - guiTop - 18);
            pose.popPose();
        }
        if (this.tabs.size() > 1) {
            for (SkillsTabScreen tabScreen : this.tabs) {
                if (!tabScreen.isMouseOver(guiLeft, guiTop, mouseX, mouseY)) continue;
                graphics.renderTooltip(this.minecraft.font, tabScreen.getTitle(), mouseX, mouseY);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.scrolling = false;
        }
        if (button == 0) {
            this.clicked = true;
            this.mousePos = new Vec3(mouseX, mouseY, 0.0);
            for (SkillsTabScreen tab : this.tabs) {
                if (tab == this.selectedTab || !tab.isMouseOver(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
                this.selectedTab = tab;
                break;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.selectedTab != null && this.minecraft.player.getEffect(ModEffects.OBLIVION) == null && this.isMouseOverContent(pMouseX, pMouseY)) {
            return this.selectedTab.mouseScrolled(pMouseX - 9.0 - (double)this.guiLeft, pMouseY - 18.0 - (double)this.guiTop, pScrollX, pScrollY);
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    private boolean isMouseOverContent(double pMouseX, double pMouseY) {
        return pMouseX > (double)(this.guiLeft + 8) && pMouseX <= (double)(this.guiLeft + 9 + 234) && pMouseY > (double)(this.guiTop + 17) && pMouseY <= (double)(this.guiTop + 18 + 173);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        block2: {
            block3: {
                block4: {
                    if (button != 0) break block2;
                    if (!this.clicked) break block3;
                    if (!this.scrolling) break block4;
                    if (this.mousePos == null) break block3;
                    Vec3 vec3 = new Vec3(mouseX, mouseY, 0.0);
                    if (!(this.mousePos.distanceTo(vec3) < 5.0)) break block3;
                }
                this.unlockSkill(mouseX, mouseY);
            }
            this.clicked = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double xDragged, double yDragged) {
        this.scrolling = true;
        if (this.selectedTab != null && this.minecraft.player.getEffect(ModEffects.OBLIVION) == null && this.isMouseOverContent(mouseX, mouseY)) {
            this.selectedTab.mouseDragged(mouseX, mouseY, mouseButton, xDragged, yDragged);
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, xDragged, yDragged);
    }

    private void unlockSkill(double mouseX, double mouseY) {
        ISkill<?> selected;
        ISkill<?> iSkill = selected = this.selectedTab != null ? this.selectedTab.getSelected((int)(mouseX - (double)this.guiLeft - 9.0), (int)(mouseY - (double)this.guiTop - 18.0)) : null;
        if (selected != null) {
            if (this.canUnlockSkill(selected)) {
                VampirismMod.proxy.sendToServer(new ServerboundUnlockSkillPacket(RegUtil.id(selected)));
                this.playSoundEffect(SoundEvents.PLAYER_LEVELUP, 0.7f);
            } else {
                this.playSoundEffect((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 0.5f);
            }
        }
    }

    private boolean canUnlockSkill(@NotNull ISkill skill) {
        if (this.factionPlayer == null) {
            return false;
        }
        return this.factionPlayer.getSkillHandler().canSkillBeEnabled(skill) == ISkillHandler.Result.OK;
    }

    private void playSoundEffect(@NotNull SoundEvent event, float pitch) {
        this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)event, (float)1.0f));
    }
}

