/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.screens.EditSelectActionScreen;
import de.teamlapen.vampirism.client.gui.screens.EditSelectMinionTaskScreen;
import de.teamlapen.vampirism.client.gui.screens.ExtendedScreen;
import de.teamlapen.vampirism.client.gui.screens.VampirePlayerAppearanceScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.client.gui.screens.taskboard.TaskList;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.inventory.TaskMenu;
import de.teamlapen.vampirism.inventory.VampirismMenu;
import de.teamlapen.vampirism.mixin.client.accessor.AbstractContainerScreenAccessor;
import de.teamlapen.vampirism.network.ServerboundDeleteRefinementPacket;
import de.teamlapen.vampirism.util.Helper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirismContainerScreen
extends AbstractContainerScreen<VampirismMenu>
implements ExtendedScreen {
    private static final ResourceLocation BACKGROUND = VResourceLocation.mod("textures/gui/container/vampirism_menu.png");
    private static final ResourceLocation BACKGROUND_REFINEMENTS = VResourceLocation.mod("textures/gui/container/vampirism_menu_refinements.png");
    private static final WidgetSprites APPEARANCE = new WidgetSprites(VResourceLocation.mod("widget/appearance"), VResourceLocation.mod("widget/appearance_highlighted"));
    private static final WidgetSprites SKILLS = new WidgetSprites(VResourceLocation.mod("widget/skills"), VResourceLocation.mod("widget/skills_highlighted"));
    private static final WidgetSprites SETTINGS = new WidgetSprites(VResourceLocation.mod("widget/settings"), VResourceLocation.mod("widget/settings_highlighted"));
    private static final WidgetSprites REMOVE_ACCESSORY = new WidgetSprites(VResourceLocation.mod("widget/remove_accessory"), VResourceLocation.mod("widget/remove_accessory_highlighted"));
    private static final WidgetSprites LOCATE_TASK_MASTER = new WidgetSprites(VResourceLocation.mod("widget/locate_task_master"), VResourceLocation.mod("widget/locate_task_master_highlighted"));
    private static final int display_width = 234;
    private static final int display_height = 205;
    private final IFactionPlayer<?> factionPlayer;
    private TaskList list;
    private final Map<Integer, Button> refinementRemoveButtons = new Int2ObjectOpenHashMap(3);
    private Component level;

    public VampirismContainerScreen(@NotNull VampirismMenu container, @NotNull Inventory playerInventory, @NotNull Component titleIn) {
        super((AbstractContainerMenu)container, playerInventory, titleIn);
        this.imageWidth = 234;
        this.imageHeight = 205;
        this.inventoryLabelX = 36;
        this.inventoryLabelY = this.imageHeight - 93;
        ((VampirismMenu)this.menu).setReloadListener(() -> this.list.updateContent());
        this.factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer(playerInventory.player).orElseThrow(() -> new IllegalStateException("Cannot open Vampirism container without faction player"));
    }

    @Override
    @NotNull
    public TaskMenu getTaskContainer() {
        return (TaskMenu)this.menu;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (ModKeys.VAMPIRISM_MENU.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        if (!this.isQuickCrafting) {
            this.list.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (((VampirismMenu)this.menu).areRefinementsAvailable()) {
            for (int i = 0; i < ((VampirismMenu)this.menu).getRefinementStacks().size(); ++i) {
                ItemStack stack = (ItemStack)((VampirismMenu)this.menu).getRefinementStacks().get(i);
                Slot slot = ((VampirismMenu)this.menu).getSlot(i);
                int x = slot.x + this.leftPos;
                int y = slot.y + this.topPos;
                graphics.renderItem(stack, x, y);
                graphics.renderItemDecorations(this.font, stack, x, y, null);
            }
        }
        this.renderAccessorySlots(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (((VampirismMenu)this.menu).areRefinementsAvailable()) {
            this.renderHoveredRefinementTooltip(graphics, mouseX, mouseY);
        }
    }

    protected void renderAccessorySlots(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Slot slot : ((VampirismMenu)this.menu).slots) {
            if (!((AbstractContainerScreenAccessor)((Object)this)).invoke_isHovering(slot, mouseX, mouseY) || !(slot instanceof VampirismMenu.RemovingSelectorSlot) || ((ItemStack)((VampirismMenu)this.menu).getRefinementStacks().get(slot.getSlotIndex())).isEmpty()) continue;
            this.refinementRemoveButtons.get(slot.getSlotIndex()).render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        super.resize(pMinecraft, pWidth, pHeight);
        this.list.updateContent();
    }

    protected void init() {
        super.init();
        if (this.factionPlayer.getLevel() > 0) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(this.factionPlayer.asEntity());
            MutableComponent component = handler.getLordLevel() > 0 ? handler.getLordTitle().copy().append(" (" + handler.getLordLevel() + ")") : Component.translatable((String)"text.vampirism.level").append(" " + this.factionPlayer.getLevel());
            this.level = component.withStyle(style -> style.withColor(this.factionPlayer.getFaction().getChatColor()));
        } else {
            this.level = Component.empty();
        }
        this.list = (TaskList)this.addRenderableWidget((GuiEventListener)new TaskList(Minecraft.getInstance(), (TaskMenu)this.menu, this.factionPlayer, this.leftPos + 83, this.topPos + 7, 137, 104, () -> new ArrayList<ITaskInstance>(((VampirismMenu)this.menu).getTaskInfos())));
        ImageButton button1 = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 7, this.topPos + 90, 20, 20, SKILLS, context -> {
            if (this.minecraft.player.isAlive() && VampirismPlayerAttributes.get((Player)this.minecraft.player).faction != null) {
                FactionPlayerHandler.getCurrentFactionPlayer((Player)this.minecraft.player).ifPresent(f -> Minecraft.getInstance().setScreen((Screen)new SkillsScreen((IFactionPlayer<?>)f, (Screen)this)));
            }
        }, (Component)Component.empty()));
        button1.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.vampirism.vampirism_menu.skill_screen")));
        ImageButton button2 = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 7, this.topPos + 126, 20, 20, SETTINGS, context -> EditSelectActionScreen.show(), (Component)Component.empty()));
        button2.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.vampirism.vampirism_menu.edit_actions")));
        ImageButton button3 = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 7, this.topPos + 147, 20, 20, SETTINGS, context -> EditSelectMinionTaskScreen.show(), (Component)Component.empty()));
        button3.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.vampirism.vampirism_menu.edit_tasks")));
        button3.visible = FactionPlayerHandler.get(this.factionPlayer.asEntity()).getLordLevel() > 0;
        Button appearanceButton = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 29, this.topPos + 90, 20, 20, APPEARANCE, context -> Minecraft.getInstance().setScreen((Screen)new VampirePlayerAppearanceScreen((Screen)this)), (Component)Component.empty()));
        appearanceButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.vampirism.vampirism_menu.appearance_menu")));
        if (!Helper.isVampire((Player)this.minecraft.player)) {
            appearanceButton.active = false;
            appearanceButton.visible = false;
        }
        final NonNullList<ItemStack> refinementList = ((VampirismMenu)this.menu).getRefinementStacks();
        for (final Slot slot : ((VampirismMenu)this.menu).slots) {
            if (!(slot instanceof VampirismMenu.RemovingSelectorSlot)) continue;
            Button xButton = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.getGuiLeft() + slot.x + 16 - 5, this.getGuiTop() + slot.y + 16 - 5, 5, 5, REMOVE_ACCESSORY, button -> {
                VampirismMod.proxy.sendToServer(new ServerboundDeleteRefinementPacket(IRefinementItem.AccessorySlotType.values()[slot.index]));
                refinementList.set(slot.index, (Object)ItemStack.EMPTY);
            }, (Component)Component.empty()){

                public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                    if (!((ItemStack)refinementList.get(slot.index)).isEmpty() && ((AbstractContainerScreenAccessor)((Object)VampirismContainerScreen.this)).getDraggingItem().isEmpty() && this.overSlot(slot, pMouseX, pMouseY)) {
                        super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                    }
                }

                private boolean overSlot(@NotNull Slot slot2, int mouseX, int mouseY) {
                    return slot2.x <= (mouseX -= VampirismContainerScreen.this.leftPos) && slot2.x + 16 > mouseX && slot2.y <= (mouseY -= VampirismContainerScreen.this.topPos) && slot2.y + 16 > mouseY;
                }
            });
            xButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.vampirism.vampirism_menu.destroy_item").withStyle(ChatFormatting.RED)));
            this.refinementRemoveButtons.put(slot.getSlotIndex(), xButton);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        int width = this.font.width((FormattedText)this.level);
        graphics.drawString(this.font, this.level, (int)Math.max(5.0f, 31.0f - (float)width / 2.0f), 81, -1, false);
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float pPartialTick, int mouseX, int mouseY) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        ResourceLocation texture = ((VampirismMenu)this.menu).areRefinementsAvailable() ? BACKGROUND_REFINEMENTS : BACKGROUND;
        graphics.blit(texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(this.leftPos + 7), (int)(this.topPos + 8), (int)(this.leftPos + 56), (int)(this.topPos + 78), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
    }

    protected void renderHoveredRefinementTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        NonNullList<ItemStack> list;
        int index;
        if (this.hoveredSlot != null && (index = this.hoveredSlot.index) < (list = ((VampirismMenu)this.menu).getRefinementStacks()).size() && index >= 0) {
            if (((VampirismMenu)this.getMenu()).getCarried().isEmpty() && !((ItemStack)list.get(index)).isEmpty()) {
                if (!this.refinementRemoveButtons.get(this.hoveredSlot.getSlotIndex()).isHoveredOrFocused()) {
                    graphics.renderTooltip(this.font, (ItemStack)list.get(index), mouseX, mouseY);
                }
            } else if (!((ItemStack)list.get(index)).isEmpty() && ((VampirismMenu)this.menu).getSlot(index).mayPlace(((VampirismMenu)this.getMenu()).getCarried())) {
                graphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.vampirism.vampirism_menu.destroy_item").withStyle(ChatFormatting.RED), mouseX, mouseY);
            }
        }
    }

    private static class TaskList
    extends de.teamlapen.vampirism.client.gui.screens.taskboard.TaskList {
        public TaskList(Minecraft minecraft, TaskMenu menu, IFactionPlayer<?> factionPlayer, int x, int y, int width, int height, Supplier<List<ITaskInstance>> itemSupplier) {
            super(minecraft, menu, factionPlayer, x, y, width, height, itemSupplier);
        }

        @Override
        protected TaskEntry createItem(ITaskInstance item) {
            return new TaskEntry(item);
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int p_283242_, int p_282891_, float p_283683_) {
            super.renderWidget(graphics, p_283242_, p_282891_, p_283683_);
            if (this.children().isEmpty()) {
                graphics.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"gui.vampirism.vampirism_menu.no_tasks"), this.getX() + this.width / 2, this.getY() + this.height / 2, 0x404040);
            }
        }

        private class TaskEntry
        extends TaskList.TaskEntry {
            @Nullable
            private ImageButton button;

            public TaskEntry(ITaskInstance taskInstance) {
                super(TaskList.this, taskInstance);
                if (!taskInstance.isUnique(TaskList.this.menu.getRegistry())) {
                    this.button = new ImageButton(0, 0, 8, 11, LOCATE_TASK_MASTER, this::clickLocator, (Component)Component.empty());
                    this.button.setTooltip(Tooltip.create((Component)this.createTooltip()));
                }
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (this.button != null && this.button.mouseClicked(mouseX, mouseY, mouseButton)) {
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, mouseButton);
            }

            @Override
            protected void renderToolTips(Minecraft minecraft, int mouseX, int mouseY) {
                if (this.button != null && !this.button.isMouseOver((double)mouseX, (double)mouseY)) {
                    super.renderToolTips(minecraft, mouseX, mouseY);
                }
            }

            private void clickLocator(Button button) {
                Player player = TaskList.this.factionPlayer.asEntity();
                Component position = (Component)((VampirismMenu)((TaskList)TaskList.this).menu).taskWrapper.get(((ITaskInstance)this.getItem()).getTaskBoard()).getLastSeenPos().map(pos -> {
                    int i = Mth.floor((float)UtilLib.horizontalDistance(player.blockPosition(), pos));
                    MutableComponent itextcomponent = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{pos.getX(), "~", pos.getZ()})).withStyle(p_241055_1_ -> p_241055_1_.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.getX() + " ~ " + pos.getZ())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
                    return itextcomponent.append((Component)Component.translatable((String)"gui.vampirism.vampirism_menu.distance", (Object[])new Object[]{i}));
                }).orElseGet(() -> Component.translatable((String)"gui.vampirism.vampirism_menu.last_known_pos.unknown").withStyle(ChatFormatting.GOLD));
                player.displayClientMessage((Component)Component.translatable((String)"gui.vampirism.vampirism_menu.last_known_pos").append(position), false);
            }

            private Component createTooltip() {
                Component position = (Component)((VampirismMenu)((TaskList)TaskList.this).menu).taskWrapper.get(((ITaskInstance)this.getItem()).getTaskBoard()).getLastSeenPos().map(pos -> Component.literal((String)("[" + pos.toShortString() + "]")).withStyle(ChatFormatting.GREEN)).orElseGet(() -> Component.translatable((String)"gui.vampirism.vampirism_menu.last_known_pos.unknown").withStyle(ChatFormatting.GOLD));
                return Component.translatable((String)"gui.vampirism.vampirism_menu.last_known_pos").append(position);
            }

            @Override
            public void render(GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                super.render(graphics, pIndex, pTop, pLeft, pWidth, pHeight, pMouseX, pMouseY, pIsMouseOver, pPartialTick);
                if (this.button != null) {
                    this.button.setPosition(pLeft + pWidth - this.button.getWidth() - 1, pTop + 1);
                    this.button.render(graphics, pMouseX, pMouseY, pPartialTick);
                }
            }
        }
    }
}

